/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class UrlFunctions {
    private static final Splitter QUERY_SPLITTER = Splitter.on((char)'&');
    private static final Splitter ARG_SPLITTER = Splitter.on((char)'=').limit(2);

    private UrlFunctions() {
    }

    @Nullable
    @Description(value="extract protocol from url")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice urlExtractProtocol(@SqlType(value="varchar") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getScheme());
    }

    @Nullable
    @Description(value="extract host from url")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice urlExtractHost(@SqlType(value="varchar") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getHost());
    }

    @Nullable
    @Description(value="extract port from url")
    @ScalarFunction
    @SqlType(value="bigint")
    public static Long urlExtractPort(@SqlType(value="varchar") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        if (uri == null || uri.getPort() < 0) {
            return null;
        }
        return uri.getPort();
    }

    @Nullable
    @Description(value="extract part from url")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice urlExtractPath(@SqlType(value="varchar") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getPath());
    }

    @Nullable
    @Description(value="extract query from url")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice urlExtractQuery(@SqlType(value="varchar") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getQuery());
    }

    @Nullable
    @Description(value="extract fragment from url")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice urlExtractFragment(@SqlType(value="varchar") Slice url) {
        URI uri = UrlFunctions.parseUrl(url);
        return uri == null ? null : UrlFunctions.slice(uri.getFragment());
    }

    @Nullable
    @Description(value="extract query parameter from url")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice urlExtractParameter(@SqlType(value="varchar") Slice url, @SqlType(value="varchar") Slice parameterName) {
        URI uri = UrlFunctions.parseUrl(url);
        if (uri == null || uri.getQuery() == null) {
            return null;
        }
        Slice query = UrlFunctions.slice(uri.getQuery());
        String parameter = parameterName.toString(Charsets.UTF_8);
        Iterable queryArgs = QUERY_SPLITTER.split((CharSequence)query.toString(Charsets.UTF_8));
        for (String queryArg : queryArgs) {
            Iterator arg = ARG_SPLITTER.split((CharSequence)queryArg).iterator();
            if (!((String)arg.next()).equals(parameter)) continue;
            if (arg.hasNext()) {
                return Slices.copiedBuffer((String)((String)arg.next()), (Charset)Charsets.UTF_8);
            }
            return Slices.EMPTY_SLICE;
        }
        return null;
    }

    private static Slice slice(@Nullable String s) {
        return Slices.copiedBuffer((String)Strings.nullToEmpty((String)s), (Charset)Charsets.UTF_8);
    }

    @Nullable
    private static URI parseUrl(Slice url) {
        try {
            return new URI(url.toString(Charsets.UTF_8));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

