/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

public final class RegexpFunctions {
    private RegexpFunctions() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="RegExp")
    public static Pattern castToRegexp(@SqlType(value="varchar") Slice pattern) {
        try {
            return Pattern.compile(pattern.toString(StandardCharsets.UTF_8));
        }
        catch (PatternSyntaxException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="returns substrings matching a regular expression")
    @ScalarFunction
    @SqlType(value="boolean")
    public static boolean regexpLike(@SqlType(value="varchar") Slice source, @SqlType(value="RegExp") Pattern pattern) {
        return pattern.matcher(source.toString(StandardCharsets.UTF_8)).find();
    }

    @Description(value="removes substrings matching a regular expression")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpReplace(@SqlType(value="varchar") Slice source, @SqlType(value="RegExp") Pattern pattern) {
        return RegexpFunctions.regexpReplace(source, pattern, Slices.EMPTY_SLICE);
    }

    @Description(value="replaces substrings matching a regular expression by given string")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpReplace(@SqlType(value="varchar") Slice source, @SqlType(value="RegExp") Pattern pattern, @SqlType(value="varchar") Slice replacement) {
        Matcher matcher = pattern.matcher(source.toString(StandardCharsets.UTF_8));
        String replaced = matcher.replaceAll(replacement.toString(StandardCharsets.UTF_8));
        return Slices.copiedBuffer((String)replaced, (Charset)StandardCharsets.UTF_8);
    }

    @Nullable
    @Description(value="string extracted using the given pattern")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpExtract(@SqlType(value="varchar") Slice source, @SqlType(value="RegExp") Pattern pattern) {
        return RegexpFunctions.regexpExtract(source, pattern, 0L);
    }

    @Nullable
    @Description(value="returns regex group of extracted string with a pattern")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpExtract(@SqlType(value="varchar") Slice source, @SqlType(value="RegExp") Pattern pattern, @SqlType(value="bigint") long group) {
        Matcher matcher = pattern.matcher(source.toString(StandardCharsets.UTF_8));
        if (group < 0L || group > (long)matcher.groupCount()) {
            throw new IllegalArgumentException("invalid group count");
        }
        if (!matcher.find()) {
            return null;
        }
        String extracted = matcher.group(Ints.checkedCast((long)group));
        return Slices.copiedBuffer((String)extracted, (Charset)StandardCharsets.UTF_8);
    }
}

