/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapKeys
extends ParametricScalar {
    public static final MapKeys MAP_KEYS = new MapKeys();
    private static final Signature SIGNATURE = new Signature("map_keys", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "array<K>", (List<String>)ImmutableList.of((Object)"map<K,V>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapKeys.class, "getKeys", Type.class, Slice.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Returns the keys of the given map<K,V> as an array";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"map_keys expects only one argument");
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(keyType);
        Signature signature = new Signature("map_keys", TypeUtils.parameterizedTypeName("array", keyType.getTypeSignature()), TypeUtils.parameterizedTypeName("map", keyType.getTypeSignature(), valueType.getTypeSignature()));
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), true, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Slice getKeys(Type keyType, Slice map) {
        ArrayList<Object> keys = new ArrayList<Object>();
        try (JsonParser parser = JSON_FACTORY.createJsonParser((InputStream)map.getInput());){
            JsonToken token = parser.nextToken();
            while (token != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    keys.add(MapKeys.parseMapKeyAsType(fieldName, keyType));
                }
                token = parser.nextToken();
                parser.skipChildren();
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
        return ArrayType.toStackRepresentation(keys);
    }

    private static Object parseMapKeyAsType(String value, Type t) {
        if (t.equals(VarcharType.VARCHAR) || t.equals(VarbinaryType.VARBINARY)) {
            return value;
        }
        if (t.equals(BigintType.BIGINT) || t.equals(TimestampType.TIMESTAMP) || t.equals(DateType.DATE)) {
            return Long.valueOf(value);
        }
        if (t.equals(DoubleType.DOUBLE)) {
            return Double.valueOf(value);
        }
        if (t.equals(BooleanType.BOOLEAN)) {
            return Boolean.valueOf(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type " + t + " not supported as a map key");
    }
}

