/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.QuarterOfYearDateTimeField;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.facebook.presto.util.ThreadLocalCache;
import com.google.common.base.Charsets;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public final class DateTimeFunctions {
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_FORMATTER_CACHE = new ThreadLocalCache<Slice, DateTimeFormatter>(100){

        @Override
        protected DateTimeFormatter load(Slice format) {
            return DateTimeFunctions.createDateTimeFormatter(format);
        }
    };
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstance((DateTimeZone)DateTimeZone.UTC);
    private static final DateTimeField SECOND_OF_MINUTE = UTC_CHRONOLOGY.secondOfMinute();
    private static final DateTimeField DAY_OF_WEEK = UTC_CHRONOLOGY.dayOfWeek();
    private static final DateTimeField DAY_OF_MONTH = UTC_CHRONOLOGY.dayOfMonth();
    private static final DateTimeField DAY_OF_YEAR = UTC_CHRONOLOGY.dayOfYear();
    private static final DateTimeField WEEK_OF_YEAR = UTC_CHRONOLOGY.weekOfWeekyear();
    private static final DateTimeField MONTH_OF_YEAR = UTC_CHRONOLOGY.monthOfYear();
    private static final DateTimeField QUARTER = QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)UTC_CHRONOLOGY);
    private static final DateTimeField YEAR = UTC_CHRONOLOGY.year();
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int MILLISECONDS_IN_MINUTE = 60000;
    private static final int MILLISECONDS_IN_HOUR = 3600000;
    private static final int MILLISECONDS_IN_DAY = 86400000;

    private DateTimeFunctions() {
    }

    @Description(value="current date")
    @ScalarFunction
    @SqlType(value="date")
    public static long currentDate(ConnectorSession session) {
        return UTC_CHRONOLOGY.dayOfMonth().roundFloor(session.getStartTime());
    }

    @Description(value="current time with time zone")
    @ScalarFunction
    @SqlType(value="time with time zone")
    public static long currentTime(ConnectorSession session) {
        long millis = DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).millisOfDay().get(session.getStartTime());
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @Description(value="current time without time zone")
    @ScalarFunction(value="localtime")
    @SqlType(value="time")
    public static long localTime(ConnectorSession session) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).millisOfDay().get(session.getStartTime());
    }

    @Description(value="current timestamp with time zone")
    @ScalarFunction(value="current_timestamp", alias={"now"})
    @SqlType(value="timestamp with time zone")
    public static long currentTimestamp(ConnectorSession session) {
        return DateTimeEncoding.packDateTimeWithZone((long)session.getStartTime(), (TimeZoneKey)session.getTimeZoneKey());
    }

    @Description(value="current timestamp without time zone")
    @ScalarFunction(value="localtimestamp")
    @SqlType(value="timestamp")
    public static long localTimestamp(ConnectorSession session) {
        return session.getStartTime();
    }

    @ScalarFunction(value="from_unixtime")
    @SqlType(value="timestamp")
    public static long fromUnixTime(@SqlType(value="double") double unixTime) {
        return Math.round(unixTime * 1000.0);
    }

    @ScalarFunction(value="from_unixtime")
    @SqlType(value="timestamp with time zone")
    public static long fromUnixTime(@SqlType(value="double") double unixTime, @SqlType(value="bigint") long hoursOffset, @SqlType(value="bigint") long minutesOffset) {
        return DateTimeEncoding.packDateTimeWithZone((long)Math.round(unixTime * 1000.0), (int)((int)(hoursOffset * 60L + minutesOffset)));
    }

    @ScalarFunction(value="to_unixtime")
    @SqlType(value="double")
    public static double toUnixTime(@SqlType(value="timestamp") long timestamp) {
        return (double)timestamp / 1000.0;
    }

    @ScalarFunction(value="to_unixtime")
    @SqlType(value="double")
    public static double toUnixTimeFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return (double)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone) / 1000.0;
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value="time with time zone")
    public static long timeAtTimeZone(@SqlType(value="time with time zone") long timeWithTimeZone, @SqlType(value="varchar") Slice zoneId) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone), (String)zoneId.toStringUtf8());
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value="time with time zone")
    public static long timeAtTimeZone(@SqlType(value="time with time zone") long timeWithTimeZone, @SqlType(value="interval day to second") long zoneOffset) {
        if (zoneOffset % 60000L != 0L) {
            throw new IllegalArgumentException("Invalid time zone offset interval: interval contains seconds");
        }
        int zoneOffsetMinutes = (int)(zoneOffset / 60000L);
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)zoneOffsetMinutes));
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value="timestamp with time zone")
    public static long timestampAtTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar") Slice zoneId) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), (String)zoneId.toStringUtf8());
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value="timestamp with time zone")
    public static long timestampAtTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="interval day to second") long zoneOffset) {
        if (zoneOffset % 60000L != 0L) {
            throw new IllegalArgumentException("Invalid time zone offset interval: interval contains seconds");
        }
        int zoneOffsetMinutes = (int)(zoneOffset / 60000L);
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)zoneOffsetMinutes));
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @SqlType(value="date")
    public static long truncateDate(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="date") long time) {
        return DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).roundFloor(time);
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @SqlType(value="time")
    public static long truncateTime(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="time") long time) {
        return DateTimeFunctions.getTimeField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).roundFloor(time);
    }

    @Description(value="truncate to the specified precision")
    @ScalarFunction(value="date_trunc")
    @SqlType(value="time with time zone")
    public static long truncateTimeWithTimeZone(@SqlType(value="varchar") Slice unit, @SqlType(value="time with time zone") long timeWithTimeZone) {
        long millis = DateTimeFunctions.getTimeField(DateTimeZoneIndex.unpackChronology(timeWithTimeZone), unit).roundFloor(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timeWithTimeZone);
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @SqlType(value="timestamp")
    public static long truncateTimestamp(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="timestamp") long timestamp) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).roundFloor(timestamp);
    }

    @Description(value="truncate to the specified precision")
    @ScalarFunction(value="date_trunc")
    @SqlType(value="timestamp with time zone")
    public static long truncateTimestampWithTimezone(@SqlType(value="varchar") Slice unit, @SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        long millis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), unit).roundFloor(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timestampWithTimeZone);
    }

    @Description(value="add the specified amount of date to the given date")
    @ScalarFunction(value="date_add")
    @SqlType(value="date")
    public static long addFieldValueDate(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="date") long date) {
        return DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).add(date, Ints.checkedCast((long)value));
    }

    @Description(value="add the specified amount of time to the given time")
    @ScalarFunction(value="date_add")
    @SqlType(value="time")
    public static long addFieldValueTime(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time") long time) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return DateTimeOperators.modulo24Hour(chronology, DateTimeFunctions.getTimeField(chronology, unit).add(time, Ints.checkedCast((long)value)));
    }

    @Description(value="add the specified amount of time to the given time")
    @ScalarFunction(value="date_add")
    @SqlType(value="time with time zone")
    public static long addFieldValueTimeWithTimeZone(@SqlType(value="varchar") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time with time zone") long timeWithTimeZone) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(timeWithTimeZone);
        long millis = DateTimeOperators.modulo24Hour(chronology, DateTimeFunctions.getTimeField(chronology, unit).add(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone), Ints.checkedCast((long)value)));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timeWithTimeZone);
    }

    @Description(value="add the specified amount of time to the given timestamp")
    @ScalarFunction(value="date_add")
    @SqlType(value="timestamp")
    public static long addFieldValueTimestamp(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp") long timestamp) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).add(timestamp, Ints.checkedCast((long)value));
    }

    @Description(value="add the specified amount of time to the given timestamp")
    @ScalarFunction(value="date_add")
    @SqlType(value="timestamp with time zone")
    public static long addFieldValueTimestampWithTimeZone(@SqlType(value="varchar") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        long millis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), unit).add(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), Ints.checkedCast((long)value));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timestampWithTimeZone);
    }

    @Description(value="difference of the given dates in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value="bigint")
    public static long diffDate(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="date") long date1, @SqlType(value="date") long date2) {
        return DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).getDifference(date2, date1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value="bigint")
    public static long diffTime(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="time") long time1, @SqlType(value="time") long time2) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return DateTimeFunctions.getTimeField(chronology, unit).getDifference(time2, time1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value="bigint")
    public static long diffTimeWithTimeZone(@SqlType(value="varchar") Slice unit, @SqlType(value="time with time zone") long timeWithTimeZone1, @SqlType(value="time with time zone") long timeWithTimeZone2) {
        return DateTimeFunctions.getTimeField(DateTimeZoneIndex.unpackChronology(timeWithTimeZone1), unit).getDifference(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone2), DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone1));
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value="bigint")
    public static long diffTimestamp(ConnectorSession session, @SqlType(value="varchar") Slice unit, @SqlType(value="timestamp") long timestamp1, @SqlType(value="timestamp") long timestamp2) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).getDifference(timestamp2, timestamp1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value="bigint")
    public static long diffTimestampWithTimeZone(@SqlType(value="varchar") Slice unit, @SqlType(value="timestamp with time zone") long timestampWithTimeZone1, @SqlType(value="timestamp with time zone") long timestampWithTimeZone2) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone1), unit).getDifference(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone2), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone1));
    }

    private static DateTimeField getDateField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toString(Charsets.UTF_8).toLowerCase(Locale.ENGLISH)) {
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid DATE field");
    }

    private static DateTimeField getTimeField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toString(Charsets.UTF_8).toLowerCase(Locale.ENGLISH)) {
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid Time field");
    }

    private static DateTimeField getTimestampField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toString(Charsets.UTF_8).toLowerCase(Locale.ENGLISH)) {
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid Timestamp field");
    }

    @Description(value="parses the specified date/time by the given format")
    @ScalarFunction
    @SqlType(value="timestamp with time zone")
    public static long parseDatetime(ConnectorSession session, @SqlType(value="varchar") Slice datetime, @SqlType(value="varchar") Slice formatString) {
        String pattern = formatString.toString(Charsets.UTF_8);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withChronology((Chronology)DateTimeZoneIndex.getChronology(session.getTimeZoneKey())).withOffsetParsed().withLocale(session.getLocale());
        String datetimeString = datetime.toString(Charsets.UTF_8);
        return DateTimeZoneIndex.packDateTimeWithZone(DateTimeFunctions.parseDateTimeHelper(formatter, datetimeString));
    }

    private static DateTime parseDateTimeHelper(DateTimeFormatter formatter, String datetimeString) {
        try {
            return formatter.parseDateTime(datetimeString);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="formats the given time by the given format")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice formatDatetime(ConnectorSession session, @SqlType(value="timestamp") long timestamp, @SqlType(value="varchar") Slice formatString) {
        return DateTimeFunctions.formatDatetime(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), session.getLocale(), timestamp, formatString);
    }

    @Description(value="formats the given time by the given format")
    @ScalarFunction(value="format_datetime")
    @SqlType(value="varchar")
    public static Slice formatDatetimeWithTimeZone(ConnectorSession session, @SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar") Slice formatString) {
        return DateTimeFunctions.formatDatetime(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), session.getLocale(), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), formatString);
    }

    private static Slice formatDatetime(ISOChronology chronology, Locale locale, long timestamp, Slice formatString) {
        String pattern = formatString.toString(Charsets.UTF_8);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withChronology((Chronology)chronology).withLocale(locale);
        String datetimeString = formatter.print(timestamp);
        return Slices.wrappedBuffer((byte[])datetimeString.getBytes(Charsets.UTF_8));
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice dateFormat(ConnectorSession session, @SqlType(value="timestamp") long timestamp, @SqlType(value="varchar") Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), session.getLocale(), timestamp, formatString);
    }

    @ScalarFunction(value="date_format")
    @SqlType(value="varchar")
    public static Slice dateFormatWithTimeZone(ConnectorSession session, @SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar") Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), session.getLocale(), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), formatString);
    }

    private static Slice dateFormat(ISOChronology chronology, Locale locale, long timestamp, Slice formatString) {
        DateTimeFormatter formatter = DATETIME_FORMATTER_CACHE.get(formatString).withChronology((Chronology)chronology).withLocale(locale);
        return Slices.copiedBuffer((String)formatter.print(timestamp), (Charset)Charsets.UTF_8);
    }

    @ScalarFunction
    @SqlType(value="timestamp")
    public static long dateParse(ConnectorSession session, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        DateTimeFormatter formatter = DATETIME_FORMATTER_CACHE.get(formatString).withChronology((Chronology)DateTimeZoneIndex.getChronology(session.getTimeZoneKey())).withLocale(session.getLocale());
        try {
            return formatter.parseMillis(dateTime.toString(Charsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="second of the minute of the given timestamp")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTimestamp(@SqlType(value="timestamp") long timestamp) {
        return SECOND_OF_MINUTE.get(timestamp);
    }

    @Description(value="second of the minute of the given timestamp")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return SECOND_OF_MINUTE.get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="second of the minute of the given time")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTime(@SqlType(value="time") long time) {
        return SECOND_OF_MINUTE.get(time);
    }

    @Description(value="second of the minute of the given time")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTimeWithTimeZone(@SqlType(value="time with time zone") long time) {
        return SECOND_OF_MINUTE.get(DateTimeEncoding.unpackMillisUtc((long)time));
    }

    @Description(value="second of the minute of the given interval")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds % 60000L / 1000L;
    }

    @Description(value="minute of the hour of the given timestamp")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).minuteOfHour().get(timestamp);
    }

    @Description(value="minute of the hour of the given timestamp")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).minuteOfHour().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="minute of the hour of the given time")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTime(ConnectorSession session, @SqlType(value="time") long time) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).minuteOfHour().get(time);
    }

    @Description(value="minute of the hour of the given time")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTimeWithTimeZone(@SqlType(value="time with time zone") long timeWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timeWithTimeZone).minuteOfHour().get(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
    }

    @Description(value="minute of the hour of the given interval")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds % 3600000L / 60000L;
    }

    @Description(value="hour of the day of the given timestamp")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).hourOfDay().get(timestamp);
    }

    @Description(value="hour of the day of the given timestamp")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).hourOfDay().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="hour of the day of the given time")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTime(ConnectorSession session, @SqlType(value="time") long time) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).hourOfDay().get(time);
    }

    @Description(value="hour of the day of the given time")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTimeWithTimeZone(@SqlType(value="time with time zone") long timeWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timeWithTimeZone).hourOfDay().get(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
    }

    @Description(value="hour of the day of the given interval")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds % 86400000L / 3600000L;
    }

    @Description(value="day of the week of the given timestamp")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value="bigint")
    public static long dayOfWeekFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).dayOfWeek().get(timestamp);
    }

    @Description(value="day of the week of the given timestamp")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value="bigint")
    public static long dayOfWeekFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfWeek().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the week of the given date")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value="bigint")
    public static long dayOfWeekFromDate(@SqlType(value="date") long date) {
        return DAY_OF_WEEK.get(date);
    }

    @Description(value="day of the month of the given timestamp")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).dayOfMonth().get(timestamp);
    }

    @Description(value="day of the month of the given timestamp")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfMonth().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the month of the given date")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromDate(@SqlType(value="date") long date) {
        return DAY_OF_MONTH.get(date);
    }

    @Description(value="day of the month of the given interval")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds / 86400000L;
    }

    @Description(value="day of the year of the given timestamp")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value="bigint")
    public static long dayOfYearFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).dayOfYear().get(timestamp);
    }

    @Description(value="day of the year of the given timestamp")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value="bigint")
    public static long dayOfYearFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfYear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the year of the given date")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value="bigint")
    public static long dayOfYearFromDate(@SqlType(value="date") long date) {
        return DAY_OF_YEAR.get(date);
    }

    @Description(value="week of the year of the given timestamp")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value="bigint")
    public static long weekFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).weekOfWeekyear().get(timestamp);
    }

    @Description(value="week of the year of the given timestamp")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value="bigint")
    public static long weekFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).weekOfWeekyear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="week of the year of the given date")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value="bigint")
    public static long weekFromDate(@SqlType(value="date") long date) {
        return WEEK_OF_YEAR.get(date);
    }

    @Description(value="month of the year of the given timestamp")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().get(timestamp);
    }

    @Description(value="month of the year of the given timestamp")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).monthOfYear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="month of the year of the given date")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromDate(@SqlType(value="date") long date) {
        return MONTH_OF_YEAR.get(date);
    }

    @Description(value="month of the year of the given interval")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromInterval(@SqlType(value="interval year to month") long months) {
        return months % 12L;
    }

    @Description(value="quarter of the year of the given timestamp")
    @ScalarFunction(value="quarter")
    @SqlType(value="bigint")
    public static long quarterFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.getChronology(session.getTimeZoneKey())).get(timestamp);
    }

    @Description(value="quarter of the year of the given timestamp")
    @ScalarFunction(value="quarter")
    @SqlType(value="bigint")
    public static long quarterFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.unpackChronology(timestampWithTimeZone)).get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="quarter of the year of the given date")
    @ScalarFunction(value="quarter")
    @SqlType(value="bigint")
    public static long quarterFromDate(@SqlType(value="date") long date) {
        return QUARTER.get(date);
    }

    @Description(value="year of the given timestamp")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).year().get(timestamp);
    }

    @Description(value="year of the given timestamp")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).year().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="year of the given date")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromDate(@SqlType(value="date") long date) {
        return YEAR.get(date);
    }

    @Description(value="year of the given interval")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromInterval(@SqlType(value="interval year to month") long months) {
        return months / 12L;
    }

    @Description(value="time zone minute of the given timestamp")
    @ScalarFunction(value="timezone_minute")
    @SqlType(value="bigint")
    public static long timeZoneMinuteFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestampWithTimeZone) % 60;
    }

    @Description(value="time zone hour of the given timestamp")
    @ScalarFunction(value="timezone_hour")
    @SqlType(value="bigint")
    public static long timeZoneHourFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestampWithTimeZone) / 60;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction(value="greatest")
    @SqlType(value="timestamp")
    public static long greatestTimestamp(@SqlType(value="timestamp") long value1, @SqlType(value="timestamp") long value2) {
        return value1 > value2 ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction(value="least")
    @SqlType(value="timestamp")
    public static long leastTimestamp(@SqlType(value="timestamp") long value1, @SqlType(value="timestamp") long value2) {
        return value1 < value2 ? value1 : value2;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction(value="greatest")
    @SqlType(value="timestamp with time zone")
    public static long greatestTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long value1, @SqlType(value="timestamp with time zone") long value2) {
        return DateTimeEncoding.unpackMillisUtc((long)value1) > DateTimeEncoding.unpackMillisUtc((long)value2) ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction(value="least")
    @SqlType(value="timestamp with time zone")
    public static long leastTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long value1, @SqlType(value="timestamp with time zone") long value2) {
        return DateTimeEncoding.unpackMillisUtc((long)value1) < DateTimeEncoding.unpackMillisUtc((long)value2) ? value1 : value2;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction(value="greatest")
    @SqlType(value="date")
    public static long greatestDate(@SqlType(value="date") long value1, @SqlType(value="date") long value2) {
        return value1 > value2 ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction(value="least")
    @SqlType(value="date")
    public static long leastDate(@SqlType(value="date") long value1, @SqlType(value="date") long value2) {
        return value1 < value2 ? value1 : value2;
    }

    public static DateTimeFormatter createDateTimeFormatter(Slice format) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        String formatString = format.toString(Charsets.UTF_8);
        boolean escaped = false;
        for (int i = 0; i < format.length(); ++i) {
            char character = formatString.charAt(i);
            if (escaped) {
                switch (character) {
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'b': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'c': {
                        builder.appendMonthOfYear(1);
                        break;
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'e': {
                        builder.appendDayOfMonth(1);
                        break;
                    }
                    case 'f': {
                        builder.appendMillisOfSecond(6);
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': 
                    case 'h': {
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'i': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'k': {
                        builder.appendClockhourOfDay(1);
                        break;
                    }
                    case 'l': {
                        builder.appendClockhourOfHalfday(1);
                        break;
                    }
                    case 'M': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'r': {
                        builder.appendClockhourOfHalfday(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendLiteral(' ').appendHalfdayOfDayText();
                        break;
                    }
                    case 'S': 
                    case 's': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'T': {
                        builder.appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2);
                        break;
                    }
                    case 'v': {
                        builder.appendWeekOfWeekyear(2);
                        break;
                    }
                    case 'x': {
                        builder.appendWeekyear(4, 4);
                        break;
                    }
                    case 'W': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'w': {
                        builder.appendDayOfWeek(1);
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'y': {
                        builder.appendYearOfCentury(2, 2);
                        break;
                    }
                    case 'D': 
                    case 'U': 
                    case 'V': 
                    case 'X': 
                    case 'u': {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("%%%s not supported in date format string", Character.valueOf(character)));
                    }
                    case '%': {
                        builder.appendLiteral('%');
                        break;
                    }
                    default: {
                        builder.appendLiteral(character);
                    }
                }
                escaped = false;
                continue;
            }
            if (character == '%') {
                escaped = true;
                continue;
            }
            builder.appendLiteral(character);
        }
        try {
            return builder.toFormatter();
        }
        catch (UnsupportedOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }
}

