/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeJsonUtils;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayToJsonCast
extends ParametricOperator {
    public static final ArrayToJsonCast ARRAY_TO_JSON = new ArrayToJsonCast();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayToJsonCast.class, "toJson", Type.class, ConnectorSession.class, Slice.class);

    private ArrayToJsonCast() {
        super(OperatorType.CAST, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("T")), "json", (List<String>)ImmutableList.of((Object)"array<T>"));
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = types.get("T");
        Type arrayType = typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)type.getTypeSignature()));
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(arrayType);
        return FunctionRegistry.operatorInfo(OperatorType.CAST, TypeSignature.parseTypeSignature((String)"json"), (List<TypeSignature>)ImmutableList.of((Object)arrayType.getTypeSignature()), methodHandle, false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Slice toJson(Type arrayType, ConnectorSession session, Slice array) {
        Object object = TypeJsonUtils.stackRepresentationToObject(session, array, arrayType);
        try {
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

