/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ArraySubscriptOperator
extends ParametricOperator {
    public static final ArraySubscriptOperator ARRAY_SUBSCRIPT = new ArraySubscriptOperator();
    private static final Map<Class<?>, MethodHandle> METHOD_HANDLES = ImmutableMap.builder().put(Boolean.TYPE, (Object)Reflection.methodHandle(ArraySubscriptOperator.class, "booleanSubscript", Slice.class, Long.TYPE)).put(Long.TYPE, (Object)Reflection.methodHandle(ArraySubscriptOperator.class, "longSubscript", Slice.class, Long.TYPE)).put(Double.TYPE, (Object)Reflection.methodHandle(ArraySubscriptOperator.class, "doubleSubscript", Slice.class, Long.TYPE)).put(Slice.class, (Object)Reflection.methodHandle(ArraySubscriptOperator.class, "sliceSubscript", Slice.class, Long.TYPE)).build();
    private static final MethodHandle STRUCTURAL_METHOD_HANDLE = Reflection.methodHandle(ArraySubscriptOperator.class, "structuralSubscript", Slice.class, Long.TYPE);
    private static final LoadingCache<CacheKey, JsonExtract.JsonExtractor<?>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(1000L).build(new CacheLoader<CacheKey, JsonExtract.JsonExtractor<?>>(){

        public JsonExtract.JsonExtractor<?> load(CacheKey key) throws Exception {
            return JsonExtract.generateExtractor(String.format("$[%d]", key.getIndex() - 1L), key.getType().getExtractor(), true);
        }
    });

    protected ArraySubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"bigint"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (String)"Expected one type, got %s", (Object[])new Object[]{types});
        Type elementType = types.get("E");
        MethodHandle methodHandle = elementType instanceof ArrayType || elementType instanceof MapType ? STRUCTURAL_METHOD_HANDLE : METHOD_HANDLES.get(elementType.getJavaType());
        Preconditions.checkNotNull((Object)methodHandle, (Object)"methodHandle is null");
        return new FunctionInfo(Signature.internalOperator(OperatorType.SUBSCRIPT.name(), elementType.getTypeSignature(), TypeUtils.parameterizedTypeName("array", elementType.getTypeSignature()), TypeSignature.parseTypeSignature((String)"bigint")), "Array subscript", true, methodHandle, true, true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static Long longSubscript(Slice array, long index) {
        return (Long)ArraySubscriptOperator.subscript(array, index, ExtractorType.LONG);
    }

    public static Boolean booleanSubscript(Slice array, long index) {
        return (Boolean)ArraySubscriptOperator.subscript(array, index, ExtractorType.BOOLEAN);
    }

    public static Double doubleSubscript(Slice array, long index) {
        return (Double)ArraySubscriptOperator.subscript(array, index, ExtractorType.DOUBLE);
    }

    public static Slice sliceSubscript(Slice array, long index) {
        return (Slice)ArraySubscriptOperator.subscript(array, index, ExtractorType.SLICE);
    }

    public static Slice structuralSubscript(Slice array, long index) {
        return (Slice)ArraySubscriptOperator.subscript(array, index, ExtractorType.STRUCTURAL);
    }

    private static <T> T subscript(Slice array, long index, ExtractorType type) {
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Index out of bounds");
        }
        JsonExtract.JsonExtractor extractor = (JsonExtract.JsonExtractor)CACHE.getUnchecked((Object)new CacheKey(index, type));
        return JsonExtract.extract(array, extractor);
    }

    private static enum ExtractorType {
        LONG(new JsonExtract.LongJsonExtractor()),
        BOOLEAN(new JsonExtract.BooleanJsonExtractor()),
        DOUBLE(new JsonExtract.DoubleJsonExtractor()),
        SLICE(new JsonExtract.ScalarValueJsonExtractor()),
        STRUCTURAL(new JsonExtract.JsonValueJsonExtractor());

        private final JsonExtract.JsonExtractor<?> extractor;

        private ExtractorType(JsonExtract.JsonExtractor<?> extractor) {
            this.extractor = extractor;
        }

        public JsonExtract.JsonExtractor<?> getExtractor() {
            return this.extractor;
        }
    }

    private static class CacheKey {
        private final long index;
        private final ExtractorType type;

        private CacheKey(long index, ExtractorType type) {
            this.index = index;
            this.type = type;
        }

        public long getIndex() {
            return this.index;
        }

        public ExtractorType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.index != cacheKey.index) {
                return false;
            }
            return this.type == cacheKey.type;
        }

        public int hashCode() {
            int result = (int)(this.index ^ this.index >>> 32);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

