/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class ArraySortFunction
extends ParametricScalar {
    public static final ArraySortFunction ARRAY_SORT_FUNCTION = new ArraySortFunction();
    private static final String FUNCTION_NAME = "array_sort";
    private static final Signature SIGNATURE = new Signature("array_sort", (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"array<E>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArraySortFunction.class, "sort", Type.class, Slice.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private static final CollectionType COLLECTION_TYPE = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, Object.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Sorts the given array in ascending order according to the natural ordering of its elements.";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)String.format("%s expects only one argument", FUNCTION_NAME));
        Type type = types.get("E");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(type);
        Signature signature = new Signature(FUNCTION_NAME, TypeUtils.parameterizedTypeName("array", type.getTypeSignature()), TypeUtils.parameterizedTypeName("array", type.getTypeSignature()));
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Slice sort(final Type type, Slice jsonArray) {
        List elements;
        try {
            elements = (List)OBJECT_MAPPER.readValue((InputStream)jsonArray.getInput(), (JavaType)COLLECTION_TYPE);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
        Collections.sort(elements, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return type.compareTo(ArraySortFunction.createBlock(type, o1), 0, ArraySortFunction.createBlock(type, o2), 0);
            }
        });
        return ArrayType.toStackRepresentation(elements);
    }

    private static Block createBlock(Type type, Object element) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        Class javaType = type.getJavaType();
        if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)element).booleanValue());
        } else if (javaType == Long.TYPE) {
            type.writeLong(blockBuilder, ((Number)element).longValue());
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Double)element).doubleValue());
        } else if (javaType == Slice.class) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)element.toString()));
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unexpected type %s", javaType.getName()));
        }
        return blockBuilder.build();
    }
}

