/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayCardinalityFunction
extends ParametricScalar {
    public static final ArrayCardinalityFunction ARRAY_CARDINALITY = new ArrayCardinalityFunction();
    private static final Signature SIGNATURE = new Signature("cardinality", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "bigint", (List<String>)ImmutableList.of((Object)"array<E>"), false, false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonFunctions.class, "jsonArrayLength", Slice.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)"Cardinality expects only one argument");
        Type type = types.get("E");
        return new FunctionInfo(new Signature("cardinality", TypeSignature.parseTypeSignature((String)"bigint"), TypeUtils.parameterizedTypeName("array", type.getTypeSignature())), "Returns the cardinality (length) of the array", false, METHOD_HANDLE, true, true, (List<Boolean>)ImmutableList.of((Object)false));
    }
}

