/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.index.DynamicTupleFilterFactory;
import com.facebook.presto.operator.index.IndexSnapshotBuilder;
import com.facebook.presto.operator.index.PageBuffer;
import com.facebook.presto.operator.index.PageBufferOperator;
import com.facebook.presto.operator.index.PagesIndexBuilderOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class IndexBuildDriverFactoryProvider {
    private final int outputOperatorId;
    private final boolean inputDriver;
    private final List<OperatorFactory> coreOperatorFactories;
    private final List<Type> outputTypes;
    private final Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory;

    public IndexBuildDriverFactoryProvider(int outputOperatorId, boolean inputDriver, List<OperatorFactory> coreOperatorFactories, Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory) {
        Preconditions.checkNotNull(coreOperatorFactories, (Object)"coreOperatorFactories is null");
        Preconditions.checkArgument((!coreOperatorFactories.isEmpty() ? 1 : 0) != 0, (Object)"coreOperatorFactories is empty");
        Preconditions.checkNotNull(dynamicTupleFilterFactory, (Object)"dynamicTupleFilterFactory is null");
        this.outputOperatorId = outputOperatorId;
        this.inputDriver = inputDriver;
        this.coreOperatorFactories = ImmutableList.copyOf(coreOperatorFactories);
        this.outputTypes = ImmutableList.copyOf(this.coreOperatorFactories.get(this.coreOperatorFactories.size() - 1).getTypes());
        this.dynamicTupleFilterFactory = dynamicTupleFilterFactory;
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public DriverFactory createSnapshot(IndexSnapshotBuilder indexSnapshotBuilder) {
        Preconditions.checkArgument((boolean)indexSnapshotBuilder.getOutputTypes().equals(this.outputTypes));
        return new DriverFactory(this.inputDriver, false, (List<OperatorFactory>)ImmutableList.builder().addAll(this.coreOperatorFactories).add((Object)new PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory(this.outputOperatorId, indexSnapshotBuilder)).build());
    }

    public DriverFactory createStreaming(PageBuffer pageBuffer, Page indexKeyTuple) {
        ImmutableList.Builder operatorFactories = ImmutableList.builder().addAll(this.coreOperatorFactories);
        if (this.dynamicTupleFilterFactory.isPresent()) {
            operatorFactories.add((Object)((DynamicTupleFilterFactory)this.dynamicTupleFilterFactory.get()).filterWithTuple(indexKeyTuple));
        }
        operatorFactories.add((Object)new PageBufferOperator.PageBufferOperatorFactory(this.outputOperatorId, pageBuffer));
        return new DriverFactory(this.inputDriver, false, (List<OperatorFactory>)operatorFactories.build());
    }
}

