/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.ParametricAggregation;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.MaxByState;
import com.facebook.presto.operator.aggregation.state.MaxByStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxByStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class MaxBy
extends ParametricAggregation {
    public static final MaxBy MAX_BY = new MaxBy();
    private static final String NAME = "max_by";
    private static final Method OUTPUT_FUNCTION = Reflection.method(MaxBy.class, "output", MaxByState.class, BlockBuilder.class);
    private static final Method INPUT_FUNCTION = Reflection.method(MaxBy.class, "input", MaxByState.class, Block.class, Block.class, Integer.TYPE);
    private static final Method COMBINE_FUNCTION = Reflection.method(MaxBy.class, "combine", MaxByState.class, MaxByState.class);
    private static final Signature SIGNATURE = new Signature("max_by", (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("K"), (Object)Signature.typeParameter("V")), "V", (List<String>)ImmutableList.of((Object)"V", (Object)"K"), false, false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public String getDescription() {
        return "Returns the value of the first argument, associated with the maximum value of the second argument";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Signature signature = new Signature(NAME, valueType.getTypeSignature(), valueType.getTypeSignature(), keyType.getTypeSignature());
        InternalAggregationFunction aggregation = MaxBy.generateAggregation(valueType, keyType);
        return new FunctionInfo(signature, this.getDescription(), aggregation.getIntermediateType().getTypeSignature(), aggregation, false);
    }

    private static InternalAggregationFunction generateAggregation(Type valueType, Type keyType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MaxBy.class.getClassLoader());
        MaxByStateSerializer stateSerializer = new MaxByStateSerializer();
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)valueType, (Object)keyType);
        MaxByStateFactory stateFactory = new MaxByStateFactory(valueType, keyType);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, valueType, (List<Type>)inputTypes), MaxBy.createInputParameterMetadata(valueType, keyType), INPUT_FUNCTION, null, null, COMBINE_FUNCTION, OUTPUT_FUNCTION, MaxByState.class, stateSerializer, stateFactory, valueType, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, valueType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, Type key) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_INPUT_CHANNEL, key), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(MaxByState state, Block value, Block key, int position) {
        if (state.getKey() == null || state.getKey().isNull(0)) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        } else if (state.getKeyType().compareTo(key, position, state.getKey(), 0) > 0) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        }
    }

    public static void combine(MaxByState state, MaxByState otherState) {
        if (state.getKey() == null) {
            state.setKey(otherState.getKey());
            state.setValue(otherState.getValue());
        } else if (state.getKeyType().compareTo(otherState.getKey(), 0, state.getKey(), 0) > 0) {
            state.setKey(otherState.getKey());
            state.setValue(otherState.getValue());
        }
    }

    public static void output(MaxByState state, BlockBuilder out) {
        if (state.getValue() == null) {
            out.appendNull();
        } else {
            state.getValueType().appendTo(state.getValue(), 0, out);
        }
    }
}

