/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class HyperLogLog {
    private final double alpha;
    private final int numberOfBuckets;

    public HyperLogLog(int numberOfBuckets) {
        Preconditions.checkArgument((boolean)HyperLogLog.isPowerOf2(numberOfBuckets), (Object)"numberOfBuckets must be a power of 2");
        Preconditions.checkArgument((numberOfBuckets > 0 ? 1 : 0) != 0, (Object)"numberOfBuckets must be > 0");
        this.numberOfBuckets = numberOfBuckets;
        this.alpha = 1.0 / (2.0 * Math.log(2.0) * (1.0 + (3.0 * Math.log(2.0) - 1.0) / (double)numberOfBuckets));
    }

    public int getSizeInBytes() {
        return this.numberOfBuckets * 1;
    }

    public void update(long hash, Slice slice, int offset) {
        int bucketMask = this.numberOfBuckets - 1;
        int bucket = (int)(hash & (long)bucketMask);
        int highestBit = Long.numberOfLeadingZeros(hash | (long)bucketMask) + 1;
        byte previous = slice.getByte(offset + bucket);
        int updated = Math.max(highestBit, previous);
        slice.setByte(offset + bucket, updated);
    }

    public void mergeInto(Slice destination, int destinationOffset, Slice source, int sourceOffset) {
        for (int bucket = 0; bucket < this.numberOfBuckets; ++bucket) {
            byte previous = destination.getByte(destinationOffset + bucket);
            byte updated = source.getByte(sourceOffset + bucket);
            if (updated <= previous) continue;
            destination.setByte(destinationOffset + bucket, (int)updated);
        }
    }

    public long estimate(Slice slice, int offset) {
        double currentSum = 0.0;
        int zeroBuckets = 0;
        for (int bucket = 0; bucket < this.numberOfBuckets; ++bucket) {
            byte value = slice.getByte(offset + bucket);
            if (value == 0) {
                ++zeroBuckets;
            }
            currentSum += 1.0 / (double)(1L << value);
        }
        double result = (double)(this.numberOfBuckets * this.numberOfBuckets) * this.alpha / currentSum;
        if ((double)zeroBuckets > 0.03 * (double)this.numberOfBuckets) {
            result = (double)this.numberOfBuckets * Math.log((double)this.numberOfBuckets * 1.0 / (double)zeroBuckets);
        }
        return Math.round(result);
    }

    public double getStandardError() {
        return 1.04 / Math.sqrt(this.numberOfBuckets);
    }

    private static boolean isPowerOf2(long value) {
        return (value & value - 1L) == 0L;
    }
}

