/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.BlockIndex;
import com.facebook.presto.operator.aggregation.NullablePosition;
import com.facebook.presto.operator.aggregation.SampleWeight;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class AggregationMetadata {
    public static final Set<Class<?>> SUPPORTED_PARAMETER_TYPES = ImmutableSet.of(Block.class, Long.TYPE, Double.TYPE, Boolean.TYPE, Slice.class);
    private final String name;
    private final List<ParameterMetadata> inputMetadata;
    private final Method inputFunction;
    private final List<ParameterMetadata> intermediateInputMetadata;
    @Nullable
    private final Method intermediateInputFunction;
    @Nullable
    private final Method combineFunction;
    @Nullable
    private final Method outputFunction;
    private final Class<?> stateInterface;
    private final AccumulatorStateSerializer<?> stateSerializer;
    private final AccumulatorStateFactory<?> stateFactory;
    private final Type outputType;
    private final boolean approximate;

    public AggregationMetadata(String name, List<ParameterMetadata> inputMetadata, Method inputFunction, @Nullable List<ParameterMetadata> intermediateInputMetadata, @Nullable Method intermediateInputFunction, @Nullable Method combineFunction, @Nullable Method outputFunction, Class<?> stateInterface, AccumulatorStateSerializer<?> stateSerializer, AccumulatorStateFactory<?> stateFactory, Type outputType, boolean approximate) {
        this.outputType = (Type)Preconditions.checkNotNull((Object)outputType);
        this.inputMetadata = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(inputMetadata, (Object)"inputMetadata is null")));
        Preconditions.checkArgument((intermediateInputFunction == null == (intermediateInputMetadata == null) ? 1 : 0) != 0, (Object)"intermediate input parameters must be specified iff an intermediate function is provided");
        this.intermediateInputMetadata = intermediateInputMetadata != null ? ImmutableList.copyOf(intermediateInputMetadata) : null;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.inputFunction = (Method)Preconditions.checkNotNull((Object)inputFunction, (Object)"inputFunction is null");
        Preconditions.checkArgument((combineFunction == null || intermediateInputFunction == null ? 1 : 0) != 0, (Object)"Aggregation cannot have both a combine and a intermediate input method");
        Preconditions.checkArgument((combineFunction != null || intermediateInputFunction != null ? 1 : 0) != 0, (Object)"Aggregation must have either a combine or a intermediate input method");
        this.intermediateInputFunction = intermediateInputFunction;
        this.combineFunction = combineFunction;
        this.outputFunction = outputFunction;
        this.stateInterface = (Class)Preconditions.checkNotNull(stateInterface, (Object)"stateInterface is null");
        this.stateSerializer = (AccumulatorStateSerializer)Preconditions.checkNotNull(stateSerializer, (Object)"stateSerializer is null");
        this.stateFactory = (AccumulatorStateFactory)Preconditions.checkNotNull(stateFactory, (Object)"stateFactory is null");
        this.approximate = approximate;
        AggregationMetadata.verifyInputFunctionSignature(inputFunction, inputMetadata, stateInterface);
        if (intermediateInputFunction != null) {
            Preconditions.checkArgument((AggregationMetadata.countInputChannels(intermediateInputMetadata) == 1 ? 1 : 0) != 0, (Object)"Intermediate input function may only have one input channel");
            AggregationMetadata.verifyInputFunctionSignature(intermediateInputFunction, intermediateInputMetadata, stateInterface);
        }
        if (combineFunction != null) {
            AggregationMetadata.verifyCombineFunction(combineFunction, stateInterface);
        }
        if (approximate) {
            AggregationMetadata.verifyApproximateOutputFunction(outputFunction, stateInterface);
        } else {
            AggregationMetadata.verifyExactOutputFunction(outputFunction, stateInterface);
        }
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public List<ParameterMetadata> getInputMetadata() {
        return this.inputMetadata;
    }

    public List<ParameterMetadata> getIntermediateInputMetadata() {
        return this.intermediateInputMetadata;
    }

    public String getName() {
        return this.name;
    }

    public Method getInputFunction() {
        return this.inputFunction;
    }

    @Nullable
    public Method getIntermediateInputFunction() {
        return this.intermediateInputFunction;
    }

    @Nullable
    public Method getCombineFunction() {
        return this.combineFunction;
    }

    @Nullable
    public Method getOutputFunction() {
        return this.outputFunction;
    }

    public Class<?> getStateInterface() {
        return this.stateInterface;
    }

    public AccumulatorStateSerializer<?> getStateSerializer() {
        return this.stateSerializer;
    }

    public AccumulatorStateFactory<?> getStateFactory() {
        return this.stateFactory;
    }

    public boolean isApproximate() {
        return this.approximate;
    }

    private static void verifyInputFunctionSignature(Method method, List<ParameterMetadata> parameterMetadatas, Class<?> stateInterface) {
        AggregationMetadata.verifyStaticAndPublic(method);
        Class<?>[] parameters = method.getParameterTypes();
        Preconditions.checkArgument((stateInterface == parameters[0] ? 1 : 0) != 0, (String)"First argument of aggregation input function must be %s", (Object[])new Object[]{stateInterface.getSimpleName()});
        Preconditions.checkArgument((parameters.length > 0 ? 1 : 0) != 0, (Object)"Aggregation input function must have at least one parameter");
        Preconditions.checkArgument((parameterMetadatas.get(0).getParameterType() == ParameterMetadata.ParameterType.STATE ? 1 : 0) != 0, (Object)"First parameter must be state");
        block6: for (int i = 1; i < parameters.length; ++i) {
            ParameterMetadata metadata = parameterMetadatas.get(i);
            switch (metadata.getParameterType()) {
                case NULLABLE_INPUT_CHANNEL: {
                    Preconditions.checkArgument((parameters[i] == Block.class ? 1 : 0) != 0, (Object)"Parameter must be Block if it has @Nullable");
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    Preconditions.checkArgument((boolean)SUPPORTED_PARAMETER_TYPES.contains(parameters[i]), (String)"Unsupported type: %s", (Object[])new Object[]{parameters[i].getSimpleName()});
                    continue block6;
                }
                case BLOCK_INDEX: {
                    Preconditions.checkArgument((parameters[i] == Integer.TYPE ? 1 : 0) != 0, (Object)"Block index parameter must be an int");
                    continue block6;
                }
                case SAMPLE_WEIGHT: {
                    Preconditions.checkArgument((parameters[i] == Long.TYPE ? 1 : 0) != 0, (Object)"Sample weight parameter must be a long");
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter: " + (Object)((Object)metadata.getParameterType()));
                }
            }
        }
    }

    private static void verifyStaticAndPublic(Method method) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)"%s is not static", (Object[])new Object[]{method.getName()});
        Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (String)"%s is not public", (Object[])new Object[]{method.getName()});
    }

    private static void verifyCombineFunction(Method method, Class<?> stateInterface) {
        AggregationMetadata.verifyStaticAndPublic(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument((parameterTypes.length == 2 && parameterTypes[0] == stateInterface && parameterTypes[1] == stateInterface ? 1 : 0) != 0, (String)"Combine function must have the signature (%s, %s)", (Object[])new Object[]{stateInterface.getSimpleName(), stateInterface.getSimpleName()});
    }

    private static void verifyApproximateOutputFunction(Method method, Class<?> stateInterface) {
        Preconditions.checkNotNull((Object)method, (Object)"Approximate aggregations must specify an output function");
        AggregationMetadata.verifyStaticAndPublic(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument((parameterTypes.length == 3 && parameterTypes[0] == stateInterface && parameterTypes[1] == Double.TYPE && parameterTypes[2] == BlockBuilder.class ? 1 : 0) != 0, (String)"Output function must have the signature (%s, double, BlockBuilder)", (Object[])new Object[]{stateInterface.getSimpleName()});
    }

    private static void verifyExactOutputFunction(Method method, Class<?> stateInterface) {
        if (method == null) {
            return;
        }
        AggregationMetadata.verifyStaticAndPublic(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument((parameterTypes.length == 2 && parameterTypes[0] == stateInterface && parameterTypes[1] == BlockBuilder.class ? 1 : 0) != 0, (String)"Output function must have the signature (%s, BlockBuilder)", (Object[])new Object[]{stateInterface.getSimpleName()});
    }

    public static int countInputChannels(List<ParameterMetadata> metadatas) {
        int parameters = 0;
        for (ParameterMetadata metadata : metadatas) {
            if (metadata.getParameterType() != ParameterMetadata.ParameterType.INPUT_CHANNEL && metadata.getParameterType() != ParameterMetadata.ParameterType.NULLABLE_INPUT_CHANNEL) continue;
            ++parameters;
        }
        return parameters;
    }

    public static class ParameterMetadata {
        private final ParameterType parameterType;
        private final Type sqlType;

        public ParameterMetadata(ParameterType parameterType) {
            this(parameterType, null);
        }

        public ParameterMetadata(ParameterType parameterType, Type sqlType) {
            Preconditions.checkArgument((sqlType == null == (parameterType != ParameterType.INPUT_CHANNEL && parameterType != ParameterType.NULLABLE_INPUT_CHANNEL) ? 1 : 0) != 0, (Object)"sqlType must be provided only for input channels");
            this.parameterType = parameterType;
            this.sqlType = sqlType;
        }

        public static ParameterMetadata fromAnnotations(Annotation[] annotations, String methodName, TypeManager typeManager) {
            List<Annotation> baseTypes = IterableTransformer.on(annotations).select(new Predicate<Annotation>(){

                public boolean apply(@Nullable Annotation input) {
                    return input instanceof SqlType || input instanceof BlockIndex || input instanceof SampleWeight;
                }
            }).list();
            boolean nullable = !FluentIterable.from(Arrays.asList(annotations)).filter(NullablePosition.class).isEmpty();
            Preconditions.checkArgument((baseTypes.size() == 1 ? 1 : 0) != 0, (String)"Parameter of %s must have exactly one of @SqlType, @BlockIndex, and @SampleWeight", (Object[])new Object[]{methodName});
            Annotation annotation = baseTypes.get(0);
            Preconditions.checkArgument((!nullable || annotation instanceof SqlType ? 1 : 0) != 0, (String)"%s contains a parameters with @Nullable that is not @SqlType", (Object[])new Object[]{methodName});
            if (annotation instanceof SqlType) {
                TypeSignature signature = TypeSignature.parseTypeSignature((String)((SqlType)annotation).value());
                if (nullable) {
                    return new ParameterMetadata(ParameterType.NULLABLE_INPUT_CHANNEL, typeManager.getType(signature));
                }
                return new ParameterMetadata(ParameterType.INPUT_CHANNEL, typeManager.getType(signature));
            }
            if (annotation instanceof BlockIndex) {
                return new ParameterMetadata(ParameterType.BLOCK_INDEX);
            }
            if (annotation instanceof SampleWeight) {
                return new ParameterMetadata(ParameterType.SAMPLE_WEIGHT);
            }
            throw new IllegalArgumentException("Unsupported annotation: " + annotation);
        }

        public ParameterType getParameterType() {
            return this.parameterType;
        }

        public Type getSqlType() {
            return this.sqlType;
        }

        public static enum ParameterType {
            INPUT_CHANNEL,
            NULLABLE_INPUT_CHANNEL,
            BLOCK_INDEX,
            SAMPLE_WEIGHT,
            STATE;

        }
    }
}

