/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import java.util.List;

public class SimpleJoinProbe
implements JoinProbe {
    private final List<Type> types;
    private final LookupSource lookupSource;
    private final int positionCount;
    private final Block[] blocks;
    private final Block[] probeBlocks;
    private int position = -1;

    private SimpleJoinProbe(List<Type> types, LookupSource lookupSource, Page page, List<Integer> probeJoinChannels) {
        int i;
        this.types = types;
        this.lookupSource = lookupSource;
        this.positionCount = page.getPositionCount();
        this.blocks = new Block[page.getChannelCount()];
        this.probeBlocks = new Block[probeJoinChannels.size()];
        for (i = 0; i < page.getChannelCount(); ++i) {
            this.blocks[i] = page.getBlock(i);
        }
        for (i = 0; i < probeJoinChannels.size(); ++i) {
            this.probeBlocks[i] = this.blocks[probeJoinChannels.get(i)];
        }
    }

    @Override
    public int getChannelCount() {
        return this.blocks.length;
    }

    @Override
    public boolean advanceNextPosition() {
        ++this.position;
        return this.position < this.positionCount;
    }

    @Override
    public void appendTo(PageBuilder pageBuilder) {
        for (int outputIndex = 0; outputIndex < this.blocks.length; ++outputIndex) {
            Type type = this.types.get(outputIndex);
            Block block = this.blocks[outputIndex];
            type.appendTo(block, this.position, pageBuilder.getBlockBuilder(outputIndex));
        }
    }

    @Override
    public long getCurrentJoinPosition() {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        return this.lookupSource.getJoinPosition(this.position, this.probeBlocks);
    }

    private boolean currentRowContainsNull() {
        for (Block probeBlock : this.probeBlocks) {
            if (!probeBlock.isNull(this.position)) continue;
            return true;
        }
        return false;
    }

    public static class SimpleJoinProbeFactory
    implements JoinProbeFactory {
        private List<Type> types;
        private List<Integer> probeJoinChannels;

        public SimpleJoinProbeFactory(List<Type> types, List<Integer> probeJoinChannels) {
            this.types = types;
            this.probeJoinChannels = probeJoinChannels;
        }

        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            return new SimpleJoinProbe(this.types, lookupSource, page, this.probeJoinChannels);
        }
    }
}

