/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class RowNumberOperator
implements Operator {
    private final OperatorContext operatorContext;
    private boolean finishing;
    private final int[] outputChannels;
    private final List<Type> types;
    private GroupByIdBlock partitionIds;
    private final Optional<GroupByHash> groupByHash;
    private Page inputPage;
    private final LongBigArray partitionRowCount;
    private final Optional<Integer> maxRowsPerPartition;

    public RowNumberOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, Optional<Integer> maxRowsPerPartition, int expectedPositions) {
        this.maxRowsPerPartition = maxRowsPerPartition;
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.outputChannels = Ints.toArray(outputChannels);
        this.partitionRowCount = new LongBigArray(0L);
        this.groupByHash = partitionChannels.isEmpty() ? Optional.absent() : Optional.of((Object)new GroupByHash(partitionTypes, Ints.toArray(partitionChannels), expectedPositions));
        this.types = RowNumberOperator.toTypes(sourceTypes, outputChannels);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        if (this.isSinglePartition() && this.maxRowsPerPartition.isPresent()) {
            return this.partitionRowCount.get(0L) == (long)((Integer)this.maxRowsPerPartition.get()).intValue();
        }
        return this.finishing && this.inputPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        if (this.isSinglePartition() && this.maxRowsPerPartition.isPresent()) {
            return this.partitionRowCount.get(0L) < (long)((Integer)this.maxRowsPerPartition.get()).intValue();
        }
        return !this.finishing && this.inputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.inputPage == null ? 1 : 0) != 0);
        this.inputPage = page;
        if (this.groupByHash.isPresent()) {
            this.partitionIds = ((GroupByHash)this.groupByHash.get()).getGroupIds(this.inputPage);
            this.partitionRowCount.ensureCapacity(this.partitionIds.getGroupCount());
        }
    }

    @Override
    public Page getOutput() {
        if (this.inputPage == null) {
            return null;
        }
        Page outputPage = this.maxRowsPerPartition.isPresent() ? this.getSelectedRows() : this.getRowsWithRowNumber();
        this.inputPage = null;
        return outputPage;
    }

    private boolean isSinglePartition() {
        return !this.groupByHash.isPresent();
    }

    private Page getRowsWithRowNumber() {
        Block rowNumberBlock = this.createRowNumberBlock();
        Block[] sourceBlocks = new Block[this.inputPage.getChannelCount()];
        for (int i = 0; i < this.outputChannels.length; ++i) {
            sourceBlocks[i] = this.inputPage.getBlock(this.outputChannels[i]);
        }
        Block[] outputBlocks = Arrays.copyOf(sourceBlocks, sourceBlocks.length + 1);
        outputBlocks[sourceBlocks.length] = rowNumberBlock;
        return new Page(this.inputPage.getPositionCount(), outputBlocks);
    }

    private Block createRowNumberBlock() {
        BlockBuilder rowNumberBlock = BigintType.BIGINT.createFixedSizeBlockBuilder(this.inputPage.getPositionCount());
        for (int currentPosition = 0; currentPosition < this.inputPage.getPositionCount(); ++currentPosition) {
            long partitionId = this.getPartitionId(currentPosition);
            long nextRowCount = this.partitionRowCount.get(partitionId) + 1L;
            BigintType.BIGINT.writeLong(rowNumberBlock, nextRowCount);
            this.partitionRowCount.set(partitionId, nextRowCount);
        }
        return rowNumberBlock.build();
    }

    private Page getSelectedRows() {
        PageBuilder pageBuilder = new PageBuilder(this.types);
        int rowNumberChannel = this.types.size() - 1;
        for (int currentPosition = 0; currentPosition < this.inputPage.getPositionCount(); ++currentPosition) {
            long partitionId = this.getPartitionId(currentPosition);
            long rowCount = this.partitionRowCount.get(partitionId);
            if (rowCount == (long)((Integer)this.maxRowsPerPartition.get()).intValue()) continue;
            for (int i = 0; i < this.outputChannels.length; ++i) {
                int channel = this.outputChannels[i];
                Type type = this.types.get(channel);
                type.appendTo(this.inputPage.getBlock(channel), currentPosition, pageBuilder.getBlockBuilder(i));
            }
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(rowNumberChannel), rowCount + 1L);
            this.partitionRowCount.set(partitionId, rowCount + 1L);
        }
        if (pageBuilder.isEmpty()) {
            return null;
        }
        return pageBuilder.build();
    }

    private long getPartitionId(int position) {
        return this.isSinglePartition() ? 0L : this.partitionIds.getGroupId(position);
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        types.add((Object)BigintType.BIGINT);
        return types.build();
    }

    public static class RowNumberOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final Optional<Integer> maxRowsPerPartition;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionTypes;
        private final int expectedPositions;
        private final List<Type> types;
        private boolean closed;

        public RowNumberOperatorFactory(int operatorId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, Optional<Integer> maxRowsPerPartition, int expectedPositions) {
            this.operatorId = operatorId;
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputChannels, (Object)"outputChannels is null")));
            this.partitionChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionChannels, (Object)"partitionChannels is null")));
            this.partitionTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionTypes, (Object)"partitionTypes is null")));
            this.maxRowsPerPartition = (Optional)Preconditions.checkNotNull(maxRowsPerPartition, (Object)"maxRowsPerPartition is null");
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions < 0");
            this.expectedPositions = expectedPositions;
            this.types = RowNumberOperator.toTypes(sourceTypes, outputChannels);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, RowNumberOperator.class.getSimpleName());
            return new RowNumberOperator(operatorContext, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.maxRowsPerPartition, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

