/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PipelineStats {
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int queuedPartitionedDrivers;
    private final int runningDrivers;
    private final int runningPartitionedDrivers;
    private final int completedDrivers;
    private final DataSize memoryReservation;
    private final Distribution.DistributionSnapshot queuedTime;
    private final Distribution.DistributionSnapshot elapsedTime;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalUserTime;
    private final Duration totalBlockedTime;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final List<OperatorStats> operatorSummaries;
    private final List<DriverStats> drivers;

    @JsonCreator
    public PipelineStats(@JsonProperty(value="inputPipeline") boolean inputPipeline, @JsonProperty(value="outputPipeline") boolean outputPipeline, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="memoryReservation") DataSize memoryReservation, @JsonProperty(value="queuedTime") Distribution.DistributionSnapshot queuedTime, @JsonProperty(value="elapsedTime") Distribution.DistributionSnapshot elapsedTime, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalUserTime") Duration totalUserTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries, @JsonProperty(value="drivers") List<DriverStats> drivers) {
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers is negative");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers is negative");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.memoryReservation = (DataSize)Preconditions.checkNotNull((Object)memoryReservation, (Object)"memoryReservation is null");
        this.queuedTime = (Distribution.DistributionSnapshot)Preconditions.checkNotNull((Object)queuedTime, (Object)"queuedTime is null");
        this.elapsedTime = (Distribution.DistributionSnapshot)Preconditions.checkNotNull((Object)elapsedTime, (Object)"elapsedTime is null");
        this.totalScheduledTime = (Duration)Preconditions.checkNotNull((Object)totalScheduledTime, (Object)"totalScheduledTime is null");
        this.totalCpuTime = (Duration)Preconditions.checkNotNull((Object)totalCpuTime, (Object)"totalCpuTime is null");
        this.totalUserTime = (Duration)Preconditions.checkNotNull((Object)totalUserTime, (Object)"totalUserTime is null");
        this.totalBlockedTime = (Duration)Preconditions.checkNotNull((Object)totalBlockedTime, (Object)"totalBlockedTime is null");
        this.rawInputDataSize = (DataSize)Preconditions.checkNotNull((Object)rawInputDataSize, (Object)"rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = (DataSize)Preconditions.checkNotNull((Object)processedInputDataSize, (Object)"processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = (DataSize)Preconditions.checkNotNull((Object)outputDataSize, (Object)"outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.operatorSummaries = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(operatorSummaries, (Object)"operatorSummaries is null")));
        this.drivers = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(drivers, (Object)"drivers is null")));
    }

    @JsonProperty
    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    @JsonProperty
    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DataSize getMemoryReservation() {
        return this.memoryReservation;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalUserTime() {
        return this.totalUserTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public List<DriverStats> getDrivers() {
        return this.drivers;
    }

    public PipelineStats summarize() {
        return new PipelineStats(this.inputPipeline, this.outputPipeline, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.runningDrivers, this.runningPartitionedDrivers, this.completedDrivers, this.memoryReservation, this.queuedTime, this.elapsedTime, this.totalScheduledTime, this.totalCpuTime, this.totalUserTime, this.totalBlockedTime, this.rawInputDataSize, this.rawInputPositions, this.processedInputDataSize, this.processedInputPositions, this.outputDataSize, this.outputPositions, this.operatorSummaries, (List<DriverStats>)ImmutableList.of());
    }

    public static Function<PipelineStats, PipelineStats> summarizePipelineStats() {
        return new Function<PipelineStats, PipelineStats>(){

            public PipelineStats apply(PipelineStats input) {
                return input.summarize();
            }
        };
    }
}

