/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class MapUnnester
extends Unnester {
    private final Type keyType;
    private final Type valueType;

    public MapUnnester(MapType mapType, @Nullable Slice slice) {
        super(2, slice);
        Preconditions.checkNotNull((Object)((Object)mapType), (Object)"mapType is null");
        this.keyType = mapType.getKeyType();
        this.valueType = mapType.getValueType();
    }

    @Override
    protected void appendTo(PageBuilder pageBuilder, int outputChannelOffset, JsonParser jsonParser) {
        block27: {
            block26: {
                BlockBuilder keyBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
                try {
                    String value = jsonParser.getCurrentName();
                    if (this.keyType.getJavaType() == Long.TYPE) {
                        this.keyType.writeLong(keyBlockBuilder, Long.valueOf(value).longValue());
                        break block26;
                    }
                    if (this.keyType.getJavaType() == Double.TYPE) {
                        this.keyType.writeDouble(keyBlockBuilder, Double.valueOf(value).doubleValue());
                        break block26;
                    }
                    if (this.keyType.getJavaType() == Boolean.TYPE) {
                        this.keyType.writeBoolean(keyBlockBuilder, Boolean.valueOf(value).booleanValue());
                        break block26;
                    }
                    if (this.keyType.getJavaType() == Slice.class) {
                        Slice slice = this.keyType.equals(VarbinaryType.VARBINARY) ? Slices.wrappedBuffer((byte[])BaseEncoding.base64().decode((CharSequence)value)) : Slices.utf8Slice((String)value);
                        this.keyType.writeSlice(keyBlockBuilder, slice);
                        break block26;
                    }
                    throw new IllegalArgumentException("Unsupported stack type: " + this.keyType.getJavaType());
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            this.readNextToken();
            BlockBuilder valueBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset + 1);
            try {
                if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                    valueBlockBuilder.appendNull();
                    break block27;
                }
                if (this.valueType instanceof ArrayType || this.valueType instanceof MapType) {
                    DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(512);
                    try (JsonGenerator jsonGenerator = JSON_FACTORY.createJsonGenerator((OutputStream)dynamicSliceOutput);){
                        jsonGenerator.copyCurrentStructure(jsonParser);
                    }
                    this.valueType.writeSlice(valueBlockBuilder, dynamicSliceOutput.slice());
                    break block27;
                }
                if (this.valueType.getJavaType() == Long.TYPE) {
                    this.valueType.writeLong(valueBlockBuilder, jsonParser.getLongValue());
                    break block27;
                }
                if (this.valueType.getJavaType() == Double.TYPE) {
                    this.valueType.writeDouble(valueBlockBuilder, jsonParser.getDoubleValue());
                    break block27;
                }
                if (this.valueType.getJavaType() == Boolean.TYPE) {
                    this.valueType.writeBoolean(valueBlockBuilder, jsonParser.getBooleanValue());
                    break block27;
                }
                if (this.valueType.getJavaType() == Slice.class) {
                    this.valueType.writeSlice(valueBlockBuilder, Slices.utf8Slice((String)jsonParser.getValueAsString()));
                    break block27;
                }
                throw new IllegalArgumentException("Unsupported stack type: " + this.valueType.getJavaType());
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

