/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SettableLookupSourceSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SettableLookupSourceSupplier lookupSourceSupplier;
    private final List<Integer> hashChannels;
    private final PagesIndex pagesIndex;
    private boolean finished;

    public HashBuilderOperator(OperatorContext operatorContext, SettableLookupSourceSupplier lookupSourceSupplier, List<Integer> hashChannels, int expectedPositions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.lookupSourceSupplier = (SettableLookupSourceSupplier)Preconditions.checkNotNull((Object)lookupSourceSupplier, (Object)"hashSupplier is null");
        Preconditions.checkArgument((!hashChannels.isEmpty() ? 1 : 0) != 0, (Object)"hashChannels is empty");
        this.hashChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hashChannels, (Object)"hashChannels is null")));
        this.pagesIndex = new PagesIndex(lookupSourceSupplier.getTypes(), expectedPositions, operatorContext);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.lookupSourceSupplier.getTypes();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        LookupSource lookupSource = this.pagesIndex.createLookupSource(this.hashChannels);
        this.lookupSourceSupplier.setLookupSource(lookupSource);
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.pagesIndex.addPage(page);
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final SettableLookupSourceSupplier lookupSourceSupplier;
        private final List<Integer> hashChannels;
        private final int expectedPositions;
        private boolean closed;

        public HashBuilderOperatorFactory(int operatorId, List<Type> types, List<Integer> hashChannels, int expectedPositions) {
            this.operatorId = operatorId;
            this.lookupSourceSupplier = new SettableLookupSourceSupplier((List)Preconditions.checkNotNull(types, (Object)"types is null"));
            Preconditions.checkArgument((!hashChannels.isEmpty() ? 1 : 0) != 0, (Object)"hashChannels is empty");
            this.hashChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hashChannels, (Object)"hashChannels is null")));
            this.expectedPositions = (Integer)Preconditions.checkNotNull((Object)expectedPositions, (Object)"expectedPositions is null");
        }

        public LookupSourceSupplier getLookupSourceSupplier() {
            return this.lookupSourceSupplier;
        }

        @Override
        public List<Type> getTypes() {
            return this.lookupSourceSupplier.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashBuilderOperator.class.getSimpleName());
            return new HashBuilderOperator(operatorContext, this.lookupSourceSupplier, this.hashChannels, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

