/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ChannelSet {
    private final GroupByHash hash;
    private final boolean containsNull;

    public ChannelSet(GroupByHash hash, boolean containsNull) {
        this.hash = hash;
        this.containsNull = containsNull;
    }

    public Type getType() {
        return this.hash.getTypes().get(0);
    }

    public long getEstimatedSizeInBytes() {
        return this.hash.getEstimatedSize();
    }

    public int size() {
        return this.hash.getGroupCount();
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean contains(int position, Block block) {
        return this.hash.contains(position, block);
    }

    public static class ChannelSetBuilder {
        private final GroupByHash hash;
        private final OperatorContext operatorContext;
        private final Block nullBlock;

        public ChannelSetBuilder(Type type, int expectedPositions, OperatorContext operatorContext) {
            this.hash = new GroupByHash((List<? extends Type>)ImmutableList.of((Object)type), new int[]{0}, expectedPositions);
            this.operatorContext = operatorContext;
            this.nullBlock = type.createBlockBuilder(new BlockBuilderStatus()).appendNull().build();
        }

        public ChannelSet build() {
            return new ChannelSet(this.hash, this.hash.contains(0, this.nullBlock));
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize();
        }

        public int size() {
            return this.hash.getGroupCount();
        }

        public void addBlock(Block block) {
            this.hash.getGroupIds(new Page(new Block[]{block}));
            if (this.operatorContext != null) {
                this.operatorContext.setMemoryReservation(this.hash.getEstimatedSize());
            }
        }

        public void add(int position, Block block) {
            this.hash.putIfAbsent(position, block);
        }
    }
}

