/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class ArrayUnnester
extends Unnester {
    private final Type elementType;

    public ArrayUnnester(ArrayType arrayType, @Nullable Slice slice) {
        super(1, slice);
        this.elementType = ((ArrayType)((Object)Preconditions.checkNotNull((Object)((Object)arrayType), (Object)"arrayType is null"))).getElementType();
    }

    @Override
    protected void appendTo(PageBuilder pageBuilder, int outputChannelOffset, JsonParser jsonParser) {
        block20: {
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
            try {
                if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                    blockBuilder.appendNull();
                    break block20;
                }
                if (this.elementType instanceof ArrayType || this.elementType instanceof MapType) {
                    DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(512);
                    try (JsonGenerator jsonGenerator = JSON_FACTORY.createJsonGenerator((OutputStream)dynamicSliceOutput);){
                        jsonGenerator.copyCurrentStructure(jsonParser);
                    }
                    this.elementType.writeSlice(blockBuilder, dynamicSliceOutput.slice());
                    break block20;
                }
                if (this.elementType.getJavaType() == Long.TYPE) {
                    this.elementType.writeLong(blockBuilder, jsonParser.getLongValue());
                    break block20;
                }
                if (this.elementType.getJavaType() == Double.TYPE) {
                    this.elementType.writeDouble(blockBuilder, jsonParser.getDoubleValue());
                    break block20;
                }
                if (this.elementType.getJavaType() == Boolean.TYPE) {
                    this.elementType.writeBoolean(blockBuilder, jsonParser.getBooleanValue());
                    break block20;
                }
                if (this.elementType.getJavaType() == Slice.class) {
                    this.elementType.writeSlice(blockBuilder, Slices.utf8Slice((String)jsonParser.getValueAsString()));
                    break block20;
                }
                throw new IllegalArgumentException("Unsupported stack type: " + this.elementType.getJavaType());
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

