/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Signature {
    private final String name;
    private final List<TypeParameter> typeParameters;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean variableArity;
    private final boolean internal;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="typeParameters") List<TypeParameter> typeParameters, @JsonProperty(value="returnType") TypeSignature returnType, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="variableArity") boolean variableArity, @JsonProperty(value="internal") boolean internal) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(typeParameters, (Object)"typeParameters is null");
        this.name = name;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
        this.returnType = (TypeSignature)Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(argumentTypes, (Object)"argumentTypes is null")));
        this.variableArity = variableArity;
        this.internal = internal;
    }

    public Signature(String name, List<TypeParameter> typeParameters, String returnType, List<String> argumentTypes, boolean variableArity, boolean internal) {
        this(name, typeParameters, TypeSignature.parseTypeSignature((String)returnType), Lists.transform(argumentTypes, TypeUtils.typeSignatureParser()), variableArity, internal);
    }

    public Signature(String name, String returnType, List<String> argumentTypes) {
        this(name, (List<TypeParameter>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)returnType), Lists.transform(argumentTypes, TypeUtils.typeSignatureParser()), false, false);
    }

    public Signature(String name, String returnType, String ... argumentTypes) {
        this(name, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public Signature(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, false, false);
    }

    public Signature(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        this(name, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalOperator(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return Signature.internalFunction(FunctionRegistry.mangleOperatorName(name), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalFunction(FunctionRegistry.mangleOperatorName(name), returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalFunction(String name, String returnType, String ... argumentTypes) {
        return Signature.internalFunction(name, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalFunction(String name, String returnType, List<String> argumentTypes) {
        return new Signature(name, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, false, true);
    }

    public static Signature internalFunction(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalFunction(name, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalFunction(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return new Signature(name, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, false, true);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    @JsonProperty
    public boolean isVariableArity() {
        return this.variableArity;
    }

    @JsonProperty
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeParameters, this.returnType, this.argumentTypes, this.variableArity, this.internal);
    }

    Signature withAlias(String name) {
        return new Signature(name, this.typeParameters, this.getReturnType(), this.getArgumentTypes(), this.variableArity, this.internal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.typeParameters, other.typeParameters) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.variableArity, other.variableArity) && Objects.equals(this.internal, other.internal);
    }

    public String toString() {
        return (this.internal ? "%" : "") + this.name + (this.typeParameters.isEmpty() ? "" : "<" + Joiner.on((String)",").join(this.typeParameters) + ">") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + this.returnType;
    }

    @Nullable
    public Map<String, Type> bindTypeParameters(Type returnType, List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        HashMap<String, TypeParameter> unboundParameters = new HashMap<String, TypeParameter>();
        for (TypeParameter parameter : this.typeParameters) {
            unboundParameters.put(parameter.getName(), parameter);
        }
        if (!Signature.matchAndBind(boundParameters, unboundParameters, this.returnType, returnType, allowCoercion, typeManager)) {
            return null;
        }
        if (!Signature.matchArguments(boundParameters, unboundParameters, this.argumentTypes, types, allowCoercion, this.variableArity, typeManager)) {
            return null;
        }
        return boundParameters;
    }

    @Nullable
    public Map<String, Type> bindTypeParameters(List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        HashMap<String, TypeParameter> unboundParameters = new HashMap<String, TypeParameter>();
        for (TypeParameter parameter : this.typeParameters) {
            unboundParameters.put(parameter.getName(), parameter);
        }
        if (!Signature.matchArguments(boundParameters, unboundParameters, this.argumentTypes, types, allowCoercion, this.variableArity, typeManager)) {
            return null;
        }
        return boundParameters;
    }

    private static boolean matchArguments(Map<String, Type> boundParameters, Map<String, TypeParameter> unboundParameters, List<TypeSignature> argumentTypes, List<? extends Type> types, boolean allowCoercion, boolean varArgs, TypeManager typeManager) {
        if (varArgs ? types.size() < argumentTypes.size() - 1 : argumentTypes.size() != types.size()) {
            return false;
        }
        for (int i = 0; i < types.size(); ++i) {
            Type type;
            TypeSignature typeSignature = argumentTypes.get(Math.min(i, argumentTypes.size() - 1));
            if (Signature.matchAndBind(boundParameters, unboundParameters, typeSignature, type = types.get(i), allowCoercion, typeManager)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAndBind(Map<String, Type> boundParameters, Map<String, TypeParameter> unboundParameters, TypeSignature signature, Type type, boolean allowCoercion, TypeManager typeManager) {
        if (boundParameters.containsKey(signature.getBase())) {
            Preconditions.checkArgument((boolean)signature.getParameters().isEmpty(), (Object)"Unexpected parameteric type");
            if (allowCoercion) {
                return FunctionRegistry.canCoerce(type, boundParameters.get(signature.getBase()));
            }
            return type.equals(boundParameters.get(signature.getBase()));
        }
        if (!signature.getParameters().isEmpty()) {
            if (type.getTypeParameters().size() != signature.getParameters().size()) {
                return false;
            }
            for (int i = 0; i < signature.getParameters().size(); ++i) {
                Type componentType = (Type)type.getTypeParameters().get(i);
                TypeSignature componentSignature = (TypeSignature)signature.getParameters().get(i);
                if (Signature.matchAndBind(boundParameters, unboundParameters, componentSignature, componentType, allowCoercion, typeManager)) continue;
                return false;
            }
        }
        if (type.equals((Object)UnknownType.UNKNOWN) && allowCoercion) {
            return true;
        }
        if (unboundParameters.containsKey(signature.getBase())) {
            TypeParameter typeParameter = unboundParameters.get(signature.getBase());
            if (!typeParameter.canBind(type)) {
                return false;
            }
            unboundParameters.remove(signature.getBase());
            boundParameters.put(signature.getBase(), type);
            return true;
        }
        if (!signature.getParameters().isEmpty()) {
            return type.getTypeSignature().getBase().equals(signature.getBase());
        }
        if (allowCoercion) {
            return FunctionRegistry.canCoerce(type, typeManager.getType(TypeSignature.parseTypeSignature((String)signature.getBase())));
        }
        return type.equals(typeManager.getType(TypeSignature.parseTypeSignature((String)signature.getBase())));
    }

    public static TypeParameter typeParameter(String name) {
        return new TypeParameter(name, false, false);
    }

    public static TypeParameter comparableTypeParameter(String name) {
        return new TypeParameter(name, true, false);
    }

    public static TypeParameter orderableTypeParameter(String name) {
        return new TypeParameter(name, false, true);
    }
}

