/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ColumnHandle {
    private final String connectorId;
    private final ConnectorColumnHandle connectorHandle;

    @JsonCreator
    public ColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="connectorHandle") ConnectorColumnHandle connectorHandle) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.connectorHandle = (ConnectorColumnHandle)Preconditions.checkNotNull((Object)connectorHandle, (Object)"connectorHandle is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public ConnectorColumnHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.connectorHandle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnHandle other = (ColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.connectorHandle, other.connectorHandle);
    }

    public String toString() {
        return this.connectorId + ":" + this.connectorHandle;
    }

    public static Function<ColumnHandle, ConnectorColumnHandle> connectorHandleGetter() {
        return new Function<ColumnHandle, ConnectorColumnHandle>(){

            public ConnectorColumnHandle apply(ColumnHandle input) {
                return input.getConnectorHandle();
            }
        };
    }

    public static Function<ConnectorColumnHandle, ColumnHandle> fromConnectorHandle(final String connectorId) {
        return new Function<ConnectorColumnHandle, ColumnHandle>(){

            public ColumnHandle apply(ConnectorColumnHandle handle) {
                return new ColumnHandle(connectorId, handle);
            }
        };
    }
}

