/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class TaskStateMachine {
    private static final Logger log = Logger.get(TaskStateMachine.class);
    private final DateTime createdTime = DateTime.now();
    private final TaskId taskId;
    private final StateMachine<TaskState> taskState;
    private final LinkedBlockingQueue<Throwable> failureCauses = new LinkedBlockingQueue();

    public TaskStateMachine(TaskId taskId, Executor executor) {
        this.taskId = (TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        this.taskState = new StateMachine<TaskState>("task " + taskId, executor, TaskState.RUNNING);
        this.taskState.addStateChangeListener(new StateMachine.StateChangeListener<TaskState>(){

            @Override
            public void stateChanged(TaskState newValue) {
                log.debug("Task %s is %s", new Object[]{TaskStateMachine.this.taskId, newValue});
            }
        });
    }

    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public TaskState getState() {
        return this.taskState.get();
    }

    public ListenableFuture<TaskState> getStateChange(TaskState currentState) {
        Preconditions.checkNotNull((Object)((Object)currentState), (Object)"currentState is null");
        Preconditions.checkArgument((!currentState.isDone() ? 1 : 0) != 0, (Object)"Current state is already done");
        ListenableFuture<TaskState> future = this.taskState.getStateChange(currentState);
        TaskState state = this.taskState.get();
        if (state.isDone()) {
            return Futures.immediateFuture((Object)((Object)state));
        }
        return future;
    }

    public LinkedBlockingQueue<Throwable> getFailureCauses() {
        return this.failureCauses;
    }

    public void finished() {
        this.transitionToDoneState(TaskState.FINISHED);
    }

    public void cancel() {
        this.transitionToDoneState(TaskState.CANCELED);
    }

    public void failed(Throwable cause) {
        this.failureCauses.add(cause);
        this.transitionToDoneState(TaskState.FAILED);
    }

    private void transitionToDoneState(TaskState doneState) {
        Preconditions.checkNotNull((Object)((Object)doneState), (Object)"doneState is null");
        Preconditions.checkArgument((boolean)doneState.isDone(), (String)"doneState %s is not a done state", (Object[])new Object[]{doneState});
        this.taskState.setIf(doneState, new Predicate<TaskState>(){

            public boolean apply(TaskState currentState) {
                return !currentState.isDone();
            }
        });
    }

    public Duration waitForStateChange(TaskState currentState, Duration maxWait) throws InterruptedException {
        return this.taskState.waitForStateChange(currentState, maxWait);
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<TaskState> stateChangeListener) {
        this.taskState.addStateChangeListener(stateChangeListener);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("taskState", this.taskState).add("failureCauses", this.failureCauses).toString();
    }
}

