/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class TaskManagerConfig {
    private boolean verboseStats;
    private boolean taskCpuTimerEnabled = true;
    private DataSize maxTaskMemoryUsage = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    private DataSize bigQueryMaxTaskMemoryUsage;
    private DataSize maxPartialAggregationMemoryUsage = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize operatorPreAllocatedMemory = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize maxTaskIndexMemoryUsage = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxShardProcessorThreads = Runtime.getRuntime().availableProcessors() * 4;
    private DataSize sinkMaxBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private Duration clientTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private Duration infoMaxAge = new Duration(15.0, TimeUnit.MINUTES);

    public boolean isVerboseStats() {
        return this.verboseStats;
    }

    @Config(value="task.verbose-stats")
    public TaskManagerConfig setVerboseStats(boolean verboseStats) {
        this.verboseStats = verboseStats;
        return this;
    }

    public boolean isTaskCpuTimerEnabled() {
        return this.taskCpuTimerEnabled;
    }

    @Config(value="task.cpu-timer-enabled")
    public TaskManagerConfig setTaskCpuTimerEnabled(boolean taskCpuTimerEnabled) {
        this.taskCpuTimerEnabled = taskCpuTimerEnabled;
        return this;
    }

    @NotNull
    public DataSize getMaxPartialAggregationMemoryUsage() {
        return this.maxPartialAggregationMemoryUsage;
    }

    @Config(value="task.max-partial-aggregation-memory")
    public TaskManagerConfig setMaxPartialAggregationMemoryUsage(DataSize maxPartialAggregationMemoryUsage) {
        this.maxPartialAggregationMemoryUsage = maxPartialAggregationMemoryUsage;
        return this;
    }

    public DataSize getBigQueryMaxTaskMemoryUsage() {
        if (this.bigQueryMaxTaskMemoryUsage == null) {
            return new DataSize((double)(2L * this.maxTaskMemoryUsage.toBytes()), DataSize.Unit.BYTE);
        }
        return this.bigQueryMaxTaskMemoryUsage;
    }

    @Config(value="experimental.big-query-max-task-memory")
    public TaskManagerConfig setBigQueryMaxTaskMemoryUsage(DataSize bigQueryMaxTaskMemoryUsage) {
        this.bigQueryMaxTaskMemoryUsage = bigQueryMaxTaskMemoryUsage;
        return this;
    }

    @NotNull
    public DataSize getMaxTaskMemoryUsage() {
        return this.maxTaskMemoryUsage;
    }

    @Config(value="task.max-memory")
    public TaskManagerConfig setMaxTaskMemoryUsage(DataSize maxTaskMemoryUsage) {
        this.maxTaskMemoryUsage = maxTaskMemoryUsage;
        return this;
    }

    @NotNull
    public DataSize getOperatorPreAllocatedMemory() {
        return this.operatorPreAllocatedMemory;
    }

    @Config(value="task.operator-pre-allocated-memory")
    public TaskManagerConfig setOperatorPreAllocatedMemory(DataSize operatorPreAllocatedMemory) {
        this.operatorPreAllocatedMemory = operatorPreAllocatedMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxTaskIndexMemoryUsage() {
        return this.maxTaskIndexMemoryUsage;
    }

    @Config(value="task.max-index-memory")
    public TaskManagerConfig setMaxTaskIndexMemoryUsage(DataSize maxTaskIndexMemoryUsage) {
        this.maxTaskIndexMemoryUsage = maxTaskIndexMemoryUsage;
        return this;
    }

    @Min(value=1L)
    public int getMaxShardProcessorThreads() {
        return this.maxShardProcessorThreads;
    }

    @Config(value="task.shard.max-threads")
    public TaskManagerConfig setMaxShardProcessorThreads(int maxShardProcessorThreads) {
        this.maxShardProcessorThreads = maxShardProcessorThreads;
        return this;
    }

    @NotNull
    public DataSize getSinkMaxBufferSize() {
        return this.sinkMaxBufferSize;
    }

    @Config(value="sink.max-buffer-size")
    public TaskManagerConfig setSinkMaxBufferSize(DataSize sinkMaxBufferSize) {
        this.sinkMaxBufferSize = sinkMaxBufferSize;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="task.client.timeout")
    public TaskManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @NotNull
    public Duration getInfoMaxAge() {
        return this.infoMaxAge;
    }

    @Config(value="task.info.max-age")
    public TaskManagerConfig setInfoMaxAge(Duration infoMaxAge) {
        this.infoMaxAge = infoMaxAge;
        return this;
    }
}

