/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StateMachine<T> {
    private static final Logger log = Logger.get(StateMachine.class);
    private final String name;
    private final Executor executor;
    @GuardedBy(value="this")
    private volatile T state;
    @GuardedBy(value="this")
    private final List<StateChangeListener<T>> stateChangeListeners = new ArrayList<StateChangeListener<T>>();
    @GuardedBy(value="this")
    private final List<SettableFuture<T>> futureStateChanges = new ArrayList<SettableFuture<T>>();

    public StateMachine(String name, Executor executor, T initialState) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.state = Preconditions.checkNotNull(initialState, (Object)"initialState is null");
    }

    public T get() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<T> getStateChange(T currentState) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not wait for state change while holding a lock on this");
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            if (!Objects.equals(this.state, currentState)) {
                return Futures.immediateFuture(this.state);
            }
            SettableFuture futureStateChange = SettableFuture.create();
            this.futureStateChanges.add(futureStateChange);
            return futureStateChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(T newState) {
        ImmutableList stateChangeListeners;
        ImmutableList futureStateChanges;
        T oldState;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not set state while holding a lock on this");
        Preconditions.checkNotNull(newState, (Object)"newState is null");
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            if (Objects.equals(this.state, newState)) {
                return this.state;
            }
            oldState = this.state;
            this.state = newState;
            futureStateChanges = ImmutableList.copyOf(this.futureStateChanges);
            this.futureStateChanges.clear();
            stateChangeListeners = ImmutableList.copyOf(this.stateChangeListeners);
            this.notifyAll();
        }
        this.fireStateChanged(newState, futureStateChanges, stateChangeListeners);
        return oldState;
    }

    public boolean setIf(T newValue, Predicate<T> predicate) {
        T currentState;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not set state while holding a lock on this");
        do {
            if (predicate.apply(currentState = this.get())) continue;
            return false;
        } while (!this.compareAndSet(currentState, newValue));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(T expectedState, T newState) {
        ImmutableList stateChangeListeners;
        ImmutableList futureStateChanges;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not set state while holding a lock on this");
        Preconditions.checkNotNull(expectedState, (Object)"expectedState is null");
        Preconditions.checkNotNull(newState, (Object)"newState is null");
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            if (!Objects.equals(this.state, expectedState)) {
                return false;
            }
            if (Objects.equals(this.state, newState)) {
                return true;
            }
            this.state = newState;
            futureStateChanges = ImmutableList.copyOf(this.futureStateChanges);
            this.futureStateChanges.clear();
            stateChangeListeners = ImmutableList.copyOf(this.stateChangeListeners);
            this.notifyAll();
        }
        this.fireStateChanged(newState, futureStateChanges, stateChangeListeners);
        return true;
    }

    private void fireStateChanged(final T newState, final ImmutableList<SettableFuture<T>> futureStateChanges, final ImmutableList<StateChangeListener<T>> stateChangeListeners) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not fire state change event while holding a lock on this");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Preconditions.checkState((!Thread.holdsLock(StateMachine.this) ? 1 : 0) != 0, (Object)"Can not notify while holding a lock on this");
                for (SettableFuture futureStateChange : futureStateChanges) {
                    try {
                        futureStateChange.set(newState);
                    }
                    catch (Throwable e) {
                        log.error(e, "Error setting future state for %s", new Object[]{StateMachine.this.name});
                    }
                }
                for (StateChangeListener stateChangeListener : stateChangeListeners) {
                    try {
                        stateChangeListener.stateChanged(newState);
                    }
                    catch (Throwable e) {
                        log.error(e, "Error notifying state change listener for %s", new Object[]{StateMachine.this.name});
                    }
                }
            }
        });
    }

    public synchronized void addStateChangeListener(StateChangeListener<T> stateChangeListener) {
        this.stateChangeListeners.add(stateChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration waitForStateChange(T currentState, Duration maxWait) throws InterruptedException {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not wait for state change while holding a lock on this");
        if (!Objects.equals(this.state, currentState)) {
            return maxWait;
        }
        long remainingNanos = maxWait.roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        long end = start + remainingNanos;
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            while (remainingNanos > 0L && Objects.equals(this.state, currentState)) {
                TimeUnit.NANOSECONDS.timedWait(this, remainingNanos);
                remainingNanos = end - System.nanoTime();
            }
        }
        if (remainingNanos < 0L) {
            remainingNanos = 0L;
        }
        return new Duration((double)remainingNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public static interface StateChangeListener<T> {
        public void stateChanged(T var1);
    }
}

