/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.concurrent.Executor;

public class SqlTaskExecutionFactory {
    private static final String VERBOSE_STATS_PROPERTY = "verbose_stats";
    private final Executor taskNotificationExecutor;
    private final TaskExecutor taskExecutor;
    private final LocalExecutionPlanner planner;
    private final QueryMonitor queryMonitor;
    private final DataSize maxTaskMemoryUsage;
    private final DataSize bigQueryMaxTaskMemoryUsage;
    private final DataSize operatorPreAllocatedMemory;
    private final boolean verboseStats;
    private final boolean cpuTimerEnabled;

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, QueryMonitor queryMonitor, TaskManagerConfig config) {
        this(taskNotificationExecutor, taskExecutor, planner, queryMonitor, config.getMaxTaskMemoryUsage(), config.getBigQueryMaxTaskMemoryUsage(), config.getOperatorPreAllocatedMemory(), config.isVerboseStats(), config.isTaskCpuTimerEnabled());
    }

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, QueryMonitor queryMonitor, DataSize maxTaskMemoryUsage, DataSize bigQueryMaxTaskMemoryUsage, DataSize operatorPreAllocatedMemory, boolean verboseStats, boolean cpuTimerEnabled) {
        this.taskNotificationExecutor = (Executor)Preconditions.checkNotNull((Object)taskNotificationExecutor, (Object)"taskNotificationExecutor is null");
        this.taskExecutor = (TaskExecutor)Preconditions.checkNotNull((Object)taskExecutor, (Object)"taskExecutor is null");
        this.planner = (LocalExecutionPlanner)Preconditions.checkNotNull((Object)planner, (Object)"planner is null");
        this.queryMonitor = (QueryMonitor)Preconditions.checkNotNull((Object)queryMonitor, (Object)"queryMonitor is null");
        this.maxTaskMemoryUsage = (DataSize)Preconditions.checkNotNull((Object)maxTaskMemoryUsage, (Object)"maxTaskMemoryUsage is null");
        this.bigQueryMaxTaskMemoryUsage = (DataSize)Preconditions.checkNotNull((Object)bigQueryMaxTaskMemoryUsage, (Object)"bigQueryMaxTaskMemoryUsage is null");
        this.operatorPreAllocatedMemory = (DataSize)Preconditions.checkNotNull((Object)operatorPreAllocatedMemory, (Object)"operatorPreAllocatedMemory is null");
        this.verboseStats = verboseStats;
        this.cpuTimerEnabled = cpuTimerEnabled;
    }

    public SqlTaskExecution create(Session session, TaskStateMachine taskStateMachine, SharedBuffer sharedBuffer, PlanFragment fragment, List<TaskSource> sources) {
        boolean verboseStats = this.getVerboseStats(session);
        TaskContext taskContext = new TaskContext(taskStateMachine, this.taskNotificationExecutor, session, SystemSessionProperties.isBigQueryEnabled(session, false) ? this.bigQueryMaxTaskMemoryUsage : this.maxTaskMemoryUsage, (DataSize)Preconditions.checkNotNull((Object)this.operatorPreAllocatedMemory, (Object)"operatorPreAllocatedMemory is null"), verboseStats, this.cpuTimerEnabled);
        return SqlTaskExecution.createSqlTaskExecution(taskStateMachine, taskContext, sharedBuffer, fragment, sources, this.planner, this.taskExecutor, this.taskNotificationExecutor, this.queryMonitor);
    }

    private boolean getVerboseStats(Session session) {
        String verboseStats = session.getSystemProperties().get(VERBOSE_STATS_PROPERTY);
        if (verboseStats == null) {
            return this.verboseStats;
        }
        try {
            return Boolean.valueOf(verboseStats.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid property 'verbose_stats=" + verboseStats + "'");
        }
    }
}

