/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.ErrorCodes;
import com.facebook.presto.Session;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class QueryStateMachine {
    private static final Logger log = Logger.get(QueryStateMachine.class);
    private final DateTime createTime = DateTime.now();
    private final long createNanos = System.nanoTime();
    private final QueryId queryId;
    private final String query;
    private final Session session;
    private final URI self;
    @GuardedBy(value="this")
    private DateTime lastHeartbeat = DateTime.now();
    @GuardedBy(value="this")
    private DateTime executionStartTime;
    @GuardedBy(value="this")
    private DateTime endTime;
    @GuardedBy(value="this")
    private Duration queuedTime;
    @GuardedBy(value="this")
    private Duration analysisTime;
    @GuardedBy(value="this")
    private Duration distributedPlanningTime;
    @GuardedBy(value="this")
    private Duration totalPlanningTime;
    private final StateMachine<QueryState> queryState;
    @GuardedBy(value="this")
    private Throwable failureCause;
    @GuardedBy(value="this")
    private List<String> outputFieldNames = ImmutableList.of();
    @GuardedBy(value="this")
    private Set<Input> inputs = ImmutableSet.of();

    public QueryStateMachine(QueryId queryId, String query, Session session, URI self, Executor executor) {
        this.queryId = (QueryId)Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.self = (URI)Preconditions.checkNotNull((Object)self, (Object)"self is null");
        this.queryState = new StateMachine<QueryState>("query " + query, executor, QueryState.QUEUED);
        this.queryState.addStateChangeListener(new StateMachine.StateChangeListener<QueryState>(){

            @Override
            public void stateChanged(QueryState newValue) {
                log.debug("Query %s is %s", new Object[]{QueryStateMachine.this.queryId, newValue});
            }
        });
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Session getSession() {
        return this.session;
    }

    public QueryInfo getQueryInfoWithoutDetails() {
        return this.getQueryInfo(null);
    }

    public synchronized QueryInfo getQueryInfo(StageInfo rootStage) {
        QueryState state = this.queryState.get();
        Duration elapsedTime = this.endTime != null ? new Duration((double)(this.endTime.getMillis() - this.createTime.getMillis()), TimeUnit.MILLISECONDS) : Duration.nanosSince((long)this.createNanos);
        FailureInfo failureInfo = null;
        ErrorCode errorCode = null;
        if (state != QueryState.FINISHED) {
            failureInfo = this.failureCause == null ? null : Failures.toFailure(this.failureCause).toFailureInfo();
            errorCode = ErrorCodes.toErrorCode(this.failureCause);
        }
        int totalTasks = 0;
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        if (rootStage != null) {
            for (StageInfo stageInfo : StageInfo.getAllStages(rootStage)) {
                StageStats stageStats = stageInfo.getStageStats();
                totalTasks += stageStats.getTotalTasks();
                runningTasks += stageStats.getRunningTasks();
                completedTasks += stageStats.getCompletedTasks();
                totalDrivers += stageStats.getTotalDrivers();
                queuedDrivers += stageStats.getQueuedDrivers();
                runningDrivers += stageStats.getRunningDrivers();
                completedDrivers += stageStats.getCompletedDrivers();
                totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
                totalScheduledTime += stageStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
                totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
                totalUserTime += stageStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
                totalBlockedTime += stageStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
                if (!stageInfo.getSubStages().isEmpty()) continue;
                rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
                rawInputPositions += stageStats.getRawInputPositions();
                processedInputDataSize += stageStats.getProcessedInputDataSize().toBytes();
                processedInputPositions += stageStats.getProcessedInputPositions();
            }
            StageStats outputStageStats = rootStage.getStageStats();
            outputDataSize += outputStageStats.getOutputDataSize().toBytes();
            outputPositions += outputStageStats.getOutputPositions();
        }
        QueryStats queryStats = new QueryStats(this.createTime, this.executionStartTime, this.lastHeartbeat, this.endTime, elapsedTime.convertToMostSuccinctTimeUnit(), this.queuedTime, this.analysisTime, this.distributedPlanningTime, this.totalPlanningTime, totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, new DataSize((double)totalMemoryReservation, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)rawInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), rawInputPositions, new DataSize((double)processedInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), processedInputPositions, new DataSize((double)outputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), outputPositions);
        return new QueryInfo(this.queryId, this.session, state, QueryStateMachine.isScheduled(rootStage), this.self, this.outputFieldNames, this.query, queryStats, rootStage, failureInfo, errorCode, this.inputs);
    }

    public synchronized void setOutputFieldNames(List<String> outputFieldNames) {
        Preconditions.checkNotNull(outputFieldNames, (Object)"outputFieldNames is null");
        this.outputFieldNames = ImmutableList.copyOf(outputFieldNames);
    }

    public synchronized void setInputs(List<Input> inputs) {
        Preconditions.checkNotNull(inputs, (Object)"inputs is null");
        this.inputs = ImmutableSet.copyOf(inputs);
    }

    public synchronized QueryState getQueryState() {
        return this.queryState.get();
    }

    public synchronized boolean isDone() {
        return this.queryState.get().isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginPlanning() {
        if (!this.queryState.compareAndSet(QueryState.QUEUED, QueryState.PLANNING)) {
            return false;
        }
        QueryStateMachine queryStateMachine = this;
        synchronized (queryStateMachine) {
            Preconditions.checkState((this.createNanos > 0L ? 1 : 0) != 0, (Object)"Can not record analysis start");
            this.queuedTime = Duration.nanosSince((long)this.createNanos).convertToMostSuccinctTimeUnit();
        }
        return true;
    }

    public synchronized boolean starting() {
        boolean changed = this.queryState.setIf(QueryState.STARTING, (Predicate<QueryState>)Predicates.in((Collection)ImmutableSet.of((Object)((Object)QueryState.QUEUED), (Object)((Object)QueryState.PLANNING))));
        if (changed) {
            this.totalPlanningTime = Duration.nanosSince((long)this.createNanos);
        }
        return changed;
    }

    public synchronized boolean running() {
        return this.queryState.setIf(QueryState.RUNNING, (Predicate<QueryState>)Predicates.not(QueryState.inDoneState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        QueryStateMachine queryStateMachine = this;
        synchronized (queryStateMachine) {
            if (this.endTime == null) {
                this.endTime = DateTime.now();
            }
        }
        return this.queryState.setIf(QueryState.FINISHED, (Predicate<QueryState>)Predicates.not(QueryState.inDoneState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        QueryStateMachine queryStateMachine = this;
        synchronized (queryStateMachine) {
            if (this.endTime == null) {
                this.endTime = DateTime.now();
            }
        }
        queryStateMachine = this;
        synchronized (queryStateMachine) {
            if (this.failureCause == null) {
                this.failureCause = new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled");
            }
        }
        return this.queryState.setIf(QueryState.CANCELED, (Predicate<QueryState>)Predicates.not(QueryState.inDoneState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fail(@Nullable Throwable cause) {
        QueryStateMachine queryStateMachine = this;
        synchronized (queryStateMachine) {
            if (this.endTime == null) {
                this.endTime = DateTime.now();
            }
        }
        queryStateMachine = this;
        synchronized (queryStateMachine) {
            if (cause != null) {
                if (this.failureCause == null) {
                    this.failureCause = cause;
                } else {
                    this.failureCause.addSuppressed(cause);
                }
            }
        }
        return this.queryState.setIf(QueryState.FAILED, (Predicate<QueryState>)Predicates.not(QueryState.inDoneState()));
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return this.queryState.waitForStateChange(currentState, maxWait);
    }

    public synchronized void recordHeartbeat() {
        this.lastHeartbeat = DateTime.now();
    }

    public synchronized void recordExecutionStart() {
        if (this.executionStartTime == null) {
            this.executionStartTime = DateTime.now();
        }
    }

    public synchronized void recordAnalysisTime(long analysisStart) {
        this.analysisTime = Duration.nanosSince((long)analysisStart).convertToMostSuccinctTimeUnit();
    }

    public synchronized void recordDistributedPlanningTime(long distributedPlanningStart) {
        this.distributedPlanningTime = Duration.nanosSince((long)distributedPlanningStart).convertToMostSuccinctTimeUnit();
    }

    private static boolean isScheduled(StageInfo rootStage) {
        if (rootStage == null) {
            return false;
        }
        return FluentIterable.from(StageInfo.getAllStages(rootStage)).transform(StageInfo.stageStateGetter()).allMatch(QueryStateMachine.isStageRunningOrDone());
    }

    private static Predicate<StageState> isStageRunningOrDone() {
        return new Predicate<StageState>(){

            public boolean apply(StageState state) {
                return state == StageState.RUNNING || state.isDone();
            }
        };
    }
}

