/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class JmxTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final String objectName;
    private final List<JmxColumnHandle> columns;

    @JsonCreator
    public JmxTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="objectName") String objectName, @JsonProperty(value="columns") List<JmxColumnHandle> columns) {
        this.connectorId = connectorId;
        this.objectName = objectName;
        this.columns = columns;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getObjectName() {
        return this.objectName;
    }

    @JsonProperty
    public List<JmxColumnHandle> getColumns() {
        return this.columns;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.objectName, this.columns});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JmxTableHandle other = (JmxTableHandle)obj;
        return Objects.equal((Object)this.connectorId, (Object)other.connectorId) && Objects.equal((Object)this.objectName, (Object)other.objectName) && Objects.equal(this.columns, other.columns);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("objectName", (Object)this.objectName).add("columns", this.columns).toString();
    }

    public ConnectorTableMetadata getTableMetadata() {
        return new ConnectorTableMetadata(new SchemaTableName("jmx", this.objectName), (List)ImmutableList.copyOf((Iterable)Iterables.transform(this.columns, JmxColumnHandle.columnMetadataGetter())));
    }
}

