/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class JmxColumnHandle
implements ConnectorColumnHandle {
    private final String connectorId;
    private final String columnName;
    private final Type columnType;
    private final int ordinalPosition;

    @JsonCreator
    public JmxColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="ordinalPosition") int ordinalPosition) {
        this.connectorId = connectorId;
        this.columnName = columnName;
        this.columnType = columnType;
        this.ordinalPosition = ordinalPosition;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.columnName, this.columnType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JmxColumnHandle other = (JmxColumnHandle)obj;
        return Objects.equal((Object)this.connectorId, (Object)other.connectorId) && Objects.equal((Object)this.columnName, (Object)other.columnName) && Objects.equal((Object)this.columnType, (Object)other.columnType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("columnName", (Object)this.columnName).add("columnType", (Object)this.columnType).toString();
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType, this.ordinalPosition, false);
    }

    public static Function<JmxColumnHandle, ColumnMetadata> columnMetadataGetter() {
        return new Function<JmxColumnHandle, ColumnMetadata>(){

            public ColumnMetadata apply(JmxColumnHandle jmxColumnHandle) {
                return jmxColumnHandle.getColumnMetadata();
            }
        };
    }
}

