/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class TaskSource {
    private final PlanNodeId planNodeId;
    private final Set<ScheduledSplit> splits;
    private final boolean noMoreSplits;

    @JsonCreator
    public TaskSource(@JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="splits") Set<ScheduledSplit> splits, @JsonProperty(value="noMoreSplits") boolean noMoreSplits) {
        this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)planNodeId, (Object)"planNodeId is null");
        this.splits = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(splits, (Object)"splits is null")));
        this.noMoreSplits = noMoreSplits;
    }

    @JsonProperty
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    public Set<ScheduledSplit> getSplits() {
        return this.splits;
    }

    @JsonProperty
    public boolean isNoMoreSplits() {
        return this.noMoreSplits;
    }

    public TaskSource update(TaskSource source) {
        Preconditions.checkArgument((boolean)this.planNodeId.equals(source.getPlanNodeId()), (String)"Expected source %s, but got source %s", (Object[])new Object[]{this.planNodeId, source.getPlanNodeId()});
        if (this.isNewer(source)) {
            Preconditions.checkArgument((!this.noMoreSplits || source.isNoMoreSplits() ? 1 : 0) != 0, (String)"Source %s has new splits, but no more splits already set", (Object[])new Object[]{this.planNodeId});
            ImmutableSet newSplits = ImmutableSet.builder().addAll(this.splits).addAll(source.getSplits()).build();
            return new TaskSource(this.planNodeId, (Set<ScheduledSplit>)newSplits, source.isNoMoreSplits());
        }
        return this;
    }

    private boolean isNewer(TaskSource source) {
        return !this.noMoreSplits && source.isNoMoreSplits() || !this.splits.containsAll(source.getSplits());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("planNodeId", (Object)this.planNodeId).add("splits", this.splits).add("noMoreSplits", this.noMoreSplits).toString();
    }
}

