/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class ThreadLocalCache<K, V> {
    private final ThreadLocal<LinkedHashMap<K, V>> cache;

    public ThreadLocalCache(final int maxSizePerThread) {
        Preconditions.checkArgument((maxSizePerThread > 0 ? 1 : 0) != 0, (Object)"max size must be greater than zero");
        this.cache = new ThreadLocal<LinkedHashMap<K, V>>(){

            @Override
            protected LinkedHashMap<K, V> initialValue() {
                return new LinkedHashMap<K, V>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                        return this.size() > maxSizePerThread;
                    }
                };
            }
        };
    }

    @Nonnull
    protected abstract V load(K var1);

    public final V get(K key) {
        LinkedHashMap<K, V> map = this.cache.get();
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        value = this.load(key);
        Preconditions.checkNotNull(value, (Object)"value must not be null");
        map.put(key, value);
        return value;
    }
}

