/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AsyncSemaphore<T> {
    private final Queue<QueuedTask<T>> queuedTasks = new ConcurrentLinkedQueue<QueuedTask<T>>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Runnable runNextTask = new Runnable(){

        @Override
        public void run() {
            AsyncSemaphore.this.runNext();
        }
    };
    private final int maxPermits;
    private final Executor submitExecutor;
    private final Function<T, ListenableFuture<?>> submitter;

    public AsyncSemaphore(int maxPermits, Executor submitExecutor, Function<T, ListenableFuture<?>> submitter) {
        Preconditions.checkArgument((maxPermits > 0 ? 1 : 0) != 0, (Object)"must have at least one permit");
        this.maxPermits = maxPermits;
        this.submitExecutor = (Executor)Preconditions.checkNotNull((Object)submitExecutor, (Object)"submitExecutor is null");
        this.submitter = (Function)Preconditions.checkNotNull(submitter, (Object)"submitter is null");
    }

    public ListenableFuture<?> submit(T task) {
        QueuedTask queuedTask = new QueuedTask(task);
        this.queuedTasks.add(queuedTask);
        this.acquirePermit();
        return queuedTask.getCompletionFuture();
    }

    private void acquirePermit() {
        if (this.counter.incrementAndGet() <= this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void releasePermit() {
        if (this.counter.getAndDecrement() > this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void runNext() {
        final QueuedTask<T> queuedTask = this.queuedTasks.poll();
        ListenableFuture<?> future = this.submitTask(queuedTask.getTask());
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                queuedTask.markCompleted();
                AsyncSemaphore.this.releasePermit();
            }

            public void onFailure(Throwable t) {
                queuedTask.markFailure(t);
                AsyncSemaphore.this.releasePermit();
            }
        });
    }

    private ListenableFuture<?> submitTask(T task) {
        try {
            ListenableFuture future = (ListenableFuture)this.submitter.apply(task);
            if (future == null) {
                return Futures.immediateFailedFuture((Throwable)new NullPointerException("Submitter returned a null future for task: " + task));
            }
            return future;
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private static class QueuedTask<T> {
        private final T task;
        private final SettableFuture<?> settableFuture = SettableFuture.create();

        private QueuedTask(T task) {
            this.task = Preconditions.checkNotNull(task, (Object)"task is null");
        }

        public T getTask() {
            return this.task;
        }

        public void markFailure(Throwable throwable) {
            this.settableFuture.setException(throwable);
        }

        public void markCompleted() {
            this.settableFuture.set(null);
        }

        public ListenableFuture<?> getCompletionFuture() {
            return this.settableFuture;
        }
    }
}

