/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.util.Types;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeJsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));
    private static final Set<Type> PASSTHROUGH_TYPES = ImmutableSet.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR);

    private TypeJsonUtils() {
    }

    public static Object stackRepresentationToObject(ConnectorSession session, Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (type instanceof ArrayType) {
            return TypeJsonUtils.arrayStackRepresentationToObject(session, Types.checkType(value, String.class, "value"), ((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return TypeJsonUtils.mapStackRepresentationToObject(session, Types.checkType(value, String.class, "value"), ((MapType)type).getKeyType(), ((MapType)type).getValueType());
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, Types.checkType(value, Boolean.class, "value").booleanValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, Types.checkType(value, Long.class, "value").longValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, Types.checkType(value, Double.class, "value").doubleValue());
        } else if (type.getJavaType() == Slice.class) {
            if (value instanceof String) {
                value = Slices.utf8Slice((String)((String)value));
            }
            type.writeSlice(blockBuilder, Types.checkType(value, Slice.class, "value"));
        }
        return type.getObjectValue(session, blockBuilder.build(), 0);
    }

    private static List<Object> arrayStackRepresentationToObject(ConnectorSession session, String stackRepresentation, Type elementType) {
        List stackElements;
        Class<?> elementJsonType = TypeJsonUtils.stackTypeToJsonClass(elementType);
        JavaType listType = OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{elementJsonType});
        try {
            stackElements = (List)OBJECT_MAPPER.readValue(stackRepresentation, listType);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (PASSTHROUGH_TYPES.contains(elementType)) {
            return stackElements;
        }
        ArrayList<Object> objectElements = new ArrayList<Object>();
        for (Object value : stackElements) {
            objectElements.add(TypeJsonUtils.stackRepresentationToObject(session, value, elementType));
        }
        return objectElements;
    }

    private static Map<Object, Object> mapStackRepresentationToObject(ConnectorSession session, String stackRepresentation, Type keyType, Type valueType) {
        Map stackMap;
        Class<?> valueJsonType = TypeJsonUtils.stackTypeToJsonClass(valueType);
        JavaType listType = OBJECT_MAPPER.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, valueJsonType});
        try {
            stackMap = (Map)OBJECT_MAPPER.readValue(stackRepresentation, listType);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        HashMap<Object, Object> objectMap = new HashMap<Object, Object>();
        for (Map.Entry entry : stackMap.entrySet()) {
            Object key = TypeJsonUtils.stackRepresentationToObject(session, TypeJsonUtils.castJsonMapKey((String)entry.getKey(), keyType), keyType);
            Object value = TypeJsonUtils.stackRepresentationToObject(session, entry.getValue(), valueType);
            objectMap.put(key, value);
        }
        return objectMap;
    }

    private static Object castJsonMapKey(String key, Type keyType) {
        if (keyType.getJavaType() == Boolean.TYPE) {
            return Boolean.valueOf(key);
        }
        if (keyType.getJavaType() == Long.TYPE) {
            return Long.valueOf(key);
        }
        if (keyType.getJavaType() == Double.TYPE) {
            return Double.valueOf(key);
        }
        if (keyType.getJavaType() == Slice.class) {
            return key;
        }
        throw new UnsupportedOperationException(String.format("Unsupported stack type: %s", keyType.getJavaType()));
    }

    private static Class<?> stackTypeToJsonClass(Type type) {
        if (type.getJavaType() == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type.getJavaType() == Long.TYPE) {
            return Long.class;
        }
        if (type.getJavaType() == Double.TYPE) {
            return Double.class;
        }
        if (type.getJavaType() == Slice.class) {
            return String.class;
        }
        if (type.getJavaType() == Void.TYPE) {
            return Void.class;
        }
        throw new UnsupportedOperationException(String.format("Unsupported stack type: %s", type.getJavaType()));
    }
}

