/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BigintOperators {
    private BigintOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="bigint")
    public static long add(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="bigint")
    public static long subtract(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="bigint")
    public static long multiply(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="bigint")
    public static long divide(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException(StandardErrorCode.DIVISION_BY_ZERO.toErrorCode(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="bigint")
    public static long modulus(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException(StandardErrorCode.DIVISION_BY_ZERO.toErrorCode(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="bigint")
    public static long negate(@SqlType(value="bigint") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="bigint") long value, @SqlType(value="bigint") long min, @SqlType(value="bigint") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="bigint") long value) {
        return value != 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="bigint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToVarchar(@SqlType(value="bigint") long value) {
        return Slices.copiedBuffer((String)String.valueOf(value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="bigint") long value) {
        return (int)(value ^ value >>> 32);
    }
}

