/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.sql.relational.optimizer.ExpressionOptimizer;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.IdentityHashMap;
import java.util.List;

public final class SqlToRowExpressionTranslator {
    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, IdentityHashMap<Expression, Type> types, Metadata metadata, Session session, boolean optimize) {
        RowExpression result = (RowExpression)new Visitor(types, metadata, session.getTimeZoneKey()).process((Node)expression, null);
        Preconditions.checkNotNull((Object)result, (Object)"translated expression is null");
        if (optimize) {
            ExpressionOptimizer optimizer = new ExpressionOptimizer(metadata.getFunctionRegistry(), metadata.getTypeManager(), session);
            return optimizer.optimize(result);
        }
        return result;
    }

    public static List<RowExpression> translate(List<Expression> expressions, IdentityHashMap<Expression, Type> types, Metadata metadata, Session session, boolean optimize) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : expressions) {
            builder.add((Object)SqlToRowExpressionTranslator.translate(expression, types, metadata, session, optimize));
        }
        return builder.build();
    }

    private static class Visitor
    extends AstVisitor<RowExpression, Void> {
        private final IdentityHashMap<Expression, Type> types;
        private final Metadata metadata;
        private final TimeZoneKey timeZoneKey;

        private Visitor(IdentityHashMap<Expression, Type> types, Metadata metadata, TimeZoneKey timeZoneKey) {
            this.types = types;
            this.metadata = metadata;
            this.timeZoneKey = timeZoneKey;
        }

        protected RowExpression visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        protected RowExpression visitInputReference(InputReference node, Void context) {
            return Expressions.field(node.getChannel(), this.types.get(node));
        }

        protected RowExpression visitNullLiteral(NullLiteral node, Void context) {
            return Expressions.constantNull((Type)UnknownType.UNKNOWN);
        }

        protected RowExpression visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)BooleanType.BOOLEAN);
        }

        protected RowExpression visitLongLiteral(LongLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)BigintType.BIGINT);
        }

        protected RowExpression visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)DoubleType.DOUBLE);
        }

        protected RowExpression visitStringLiteral(StringLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)VarcharType.VARCHAR);
        }

        protected RowExpression visitGenericLiteral(GenericLiteral node, Void context) {
            Type type = this.metadata.getType(node.getType());
            if (type == null) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            return Expressions.call(Signatures.castSignature(this.types.get(node), (Type)VarcharType.VARCHAR), this.types.get(node), Expressions.constant(Slices.copiedBuffer((String)node.getValue(), (Charset)StandardCharsets.UTF_8), (Type)VarcharType.VARCHAR));
        }

        protected RowExpression visitTimeLiteral(TimeLiteral node, Void context) {
            long value = this.types.get(node).equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) ? DateTimeUtils.parseTimeWithTimeZone(node.getValue()) : DateTimeUtils.parseTimeWithoutTimeZone(this.timeZoneKey, node.getValue());
            return Expressions.constant(value, this.types.get(node));
        }

        protected RowExpression visitTimestampLiteral(TimestampLiteral node, Void context) {
            long value = this.types.get(node).equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) ? DateTimeUtils.parseTimestampWithTimeZone(node.getValue()) : DateTimeUtils.parseTimestampWithoutTimeZone(this.timeZoneKey, node.getValue());
            return Expressions.constant(value, this.types.get(node));
        }

        protected RowExpression visitIntervalLiteral(IntervalLiteral node, Void context) {
            long value = node.isYearToMonth() ? (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()) : (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
            return Expressions.constant(value, this.types.get(node));
        }

        protected RowExpression visitComparisonExpression(ComparisonExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(Signatures.comparisonExpressionSignature(node.getType(), left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, left, right);
        }

        protected RowExpression visitFunctionCall(FunctionCall node, Void context) {
            List arguments = Lists.transform((List)node.getArguments(), (Function)this.processFunction(context));
            List argumentTypes = Lists.transform((List)Lists.transform((List)arguments, RowExpression.typeGetter()), TypeUtils.nameGetter());
            Signature signature = new Signature(node.getName().getSuffix(), this.types.get(node).getName(), argumentTypes);
            return Expressions.call(signature, this.types.get(node), arguments);
        }

        protected RowExpression visitArithmeticExpression(ArithmeticExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(Signatures.arithmeticExpressionSignature(node.getType(), this.types.get(node), left.getType(), right.getType()), this.types.get(node), left, right);
        }

        protected RowExpression visitNegativeExpression(NegativeExpression node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call(Signatures.arithmeticNegationSignature(this.types.get(node), expression.getType()), this.types.get(node), expression);
        }

        protected RowExpression visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return Expressions.call(Signatures.logicalExpressionSignature(node.getType()), (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getLeft(), context), (RowExpression)this.process((Node)node.getRight(), context));
        }

        protected RowExpression visitCast(Cast node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getExpression(), context);
            if (node.isSafe()) {
                return Expressions.call(Signatures.tryCastSignature(this.types.get(node), value.getType()), this.types.get(node), value);
            }
            return Expressions.call(Signatures.castSignature(this.types.get(node), value.getType()), this.types.get(node), value);
        }

        protected RowExpression visitCoalesceExpression(CoalesceExpression node, Void context) {
            List arguments = Lists.transform((List)node.getOperands(), (Function)this.processFunction(context));
            List argumentTypes = Lists.transform((List)arguments, RowExpression.typeGetter());
            return Expressions.call(Signatures.coalesceSignature(this.types.get(node), argumentTypes), this.types.get(node), arguments);
        }

        protected RowExpression visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getOperand(), context));
            for (WhenClause clause : node.getWhenClauses()) {
                arguments.add((Object)Expressions.call(Signatures.whenSignature(this.types.get(clause)), this.types.get(clause), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context)));
            }
            Type returnType = this.types.get(node);
            if (node.getDefaultValue() != null) {
                arguments.add(this.process((Node)node.getDefaultValue(), context));
            } else {
                arguments.add((Object)Expressions.constantNull(returnType));
            }
            return Expressions.call(Signatures.switchSignature(returnType), returnType, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            RowExpression expression = Expressions.constantNull(this.types.get(node));
            if (node.getDefaultValue() != null) {
                expression = (RowExpression)this.process((Node)node.getDefaultValue(), context);
            }
            for (WhenClause clause : Lists.reverse((List)node.getWhenClauses())) {
                expression = Expressions.call(Signatures.ifSignature(this.types.get(node)), this.types.get(node), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context), expression);
            }
            return expression;
        }

        protected RowExpression visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getCondition(), context)).add(this.process((Node)node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                arguments.add(this.process((Node)node.getFalseValue().get(), context));
            } else {
                arguments.add((Object)Expressions.constantNull(this.types.get(node)));
            }
            return Expressions.call(Signatures.ifSignature(this.types.get(node)), this.types.get(node), (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitInPredicate(InPredicate node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getValue(), context));
            InListExpression values = (InListExpression)node.getValueList();
            for (Expression value : values.getValues()) {
                arguments.add(this.process((Node)value, context));
            }
            return Expressions.call(Signatures.inSignature(), (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call(Signatures.notSignature(), (Type)BooleanType.BOOLEAN, Expressions.call(Signatures.isNullSignature(expression.getType()), (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression)));
        }

        protected RowExpression visitIsNullPredicate(IsNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call(Signatures.isNullSignature(expression.getType()), (Type)BooleanType.BOOLEAN, expression);
        }

        protected RowExpression visitNotExpression(NotExpression node, Void context) {
            return Expressions.call(Signatures.notSignature(), (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getValue(), context));
        }

        protected RowExpression visitNullIfExpression(NullIfExpression node, Void context) {
            RowExpression first = (RowExpression)this.process((Node)node.getFirst(), context);
            RowExpression second = (RowExpression)this.process((Node)node.getSecond(), context);
            return Expressions.call(Signatures.nullIfSignature(this.types.get(node), first.getType(), second.getType()), this.types.get(node), first, second);
        }

        protected RowExpression visitBetweenPredicate(BetweenPredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression min = (RowExpression)this.process((Node)node.getMin(), context);
            RowExpression max = (RowExpression)this.process((Node)node.getMax(), context);
            return Expressions.call(Signatures.betweenSignature(value.getType(), min.getType(), max.getType()), (Type)BooleanType.BOOLEAN, value, min, max);
        }

        protected RowExpression visitLikePredicate(LikePredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression pattern = (RowExpression)this.process((Node)node.getPattern(), context);
            if (node.getEscape() != null) {
                RowExpression escape = (RowExpression)this.process((Node)node.getEscape(), context);
                return Expressions.call(Signatures.likeSignature(), (Type)BooleanType.BOOLEAN, value, Expressions.call(Signatures.likePatternSignature(), (Type)LikePatternType.LIKE_PATTERN, pattern, escape));
            }
            return Expressions.call(Signatures.likeSignature(), (Type)BooleanType.BOOLEAN, value, Expressions.call(Signatures.castSignature((Type)LikePatternType.LIKE_PATTERN, (Type)VarcharType.VARCHAR), (Type)LikePatternType.LIKE_PATTERN, pattern));
        }

        protected RowExpression visitSubscriptExpression(SubscriptExpression node, Void context) {
            RowExpression base = (RowExpression)this.process((Node)node.getBase(), context);
            RowExpression index = (RowExpression)this.process((Node)node.getIndex(), context);
            return Expressions.call(Signatures.subscriptSignature(this.types.get(node), base.getType(), index.getType()), this.types.get(node), base, index);
        }

        protected RowExpression visitArrayConstructor(ArrayConstructor node, Void context) {
            List arguments = Lists.transform((List)node.getValues(), (Function)this.processFunction(context));
            List argumentTypes = Lists.transform((List)arguments, RowExpression.typeGetter());
            return Expressions.call(Signatures.arrayConstructorSignature(this.types.get(node), argumentTypes), this.types.get(node), arguments);
        }
    }
}

