/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public final class Signatures {
    public static final String IF = "IF";
    public static final String NULL_IF = "NULL_IF";
    public static final String SWITCH = "SWITCH";
    public static final String CAST = FunctionRegistry.mangleOperatorName("CAST");
    public static final String TRY_CAST = "TRY_CAST";
    public static final String IS_NULL = "IS_NULL";
    public static final String COALESCE = "COALESCE";
    public static final String IN = "IN";

    private Signatures() {
    }

    public static Signature notSignature() {
        return new Signature("not", "boolean", (List<String>)ImmutableList.of((Object)"boolean"));
    }

    public static Signature betweenSignature(Type valueType, Type minType, Type maxType) {
        return Signature.internalOperator("BETWEEN", "boolean", valueType.getName(), minType.getName(), maxType.getName());
    }

    public static Signature likeSignature() {
        return Signature.internalFunction("LIKE", "boolean", "varchar", "LikePattern");
    }

    public static Signature likePatternSignature() {
        return Signature.internalFunction("LIKE_PATTERN", "LikePattern", "varchar", "varchar");
    }

    public static Signature castSignature(Type returnType, Type valueType) {
        return Signature.internalFunction(CAST, returnType.getName(), valueType.getName());
    }

    public static Signature tryCastSignature(Type returnType, Type valueType) {
        return Signature.internalFunction(TRY_CAST, returnType.getName(), valueType.getName());
    }

    public static Signature logicalExpressionSignature(LogicalBinaryExpression.Type expressionType) {
        return Signature.internalFunction(expressionType.name(), "boolean", "boolean", "boolean");
    }

    public static Signature arithmeticNegationSignature(Type returnType, Type valueType) {
        return Signature.internalOperator("NEGATION", returnType.getName(), valueType.getName());
    }

    public static Signature arithmeticExpressionSignature(ArithmeticExpression.Type expressionType, Type returnType, Type leftType, Type rightType) {
        return Signature.internalOperator(expressionType.name(), returnType.getName(), leftType.getName(), rightType.getName());
    }

    public static Signature subscriptSignature(Type returnType, Type leftType, Type rightType) {
        return Signature.internalOperator(OperatorType.SUBSCRIPT.name(), returnType.getName(), leftType.getName(), rightType.getName());
    }

    public static Signature arrayConstructorSignature(Type returnType, List<? extends Type> argumentTypes) {
        return Signature.internalFunction("ARRAY_CONSTRUCTOR", returnType.getName(), Lists.transform(argumentTypes, TypeUtils.nameGetter()));
    }

    public static Signature arrayConstructorSignature(String returnType, List<String> argumentTypes) {
        return Signature.internalFunction("ARRAY_CONSTRUCTOR", returnType, argumentTypes);
    }

    public static Signature comparisonExpressionSignature(ComparisonExpression.Type expressionType, Type leftType, Type rightType) {
        for (OperatorType operatorType : OperatorType.values()) {
            if (!operatorType.name().equals(expressionType.name())) continue;
            return Signature.internalOperator(expressionType.name(), "boolean", leftType.getName(), rightType.getName());
        }
        return Signature.internalFunction(expressionType.name(), "boolean", leftType.getName(), rightType.getName());
    }

    public static Signature ifSignature(Type returnType) {
        return new Signature(IF, returnType.getName(), new String[0]);
    }

    public static Signature nullIfSignature(Type returnType, Type firstType, Type secondType) {
        return new Signature(NULL_IF, returnType.getName(), firstType.getName(), secondType.getName());
    }

    public static Signature switchSignature(Type returnType) {
        return new Signature(SWITCH, returnType.getName(), new String[0]);
    }

    public static Signature whenSignature(Type returnType) {
        return new Signature("WHEN", returnType.getName(), new String[0]);
    }

    public static Signature inSignature() {
        return Signature.internalFunction(IN, "boolean", new String[0]);
    }

    public static Signature isNullSignature(Type argumentType) {
        return Signature.internalFunction(IS_NULL, "boolean", argumentType.getName());
    }

    public static Signature coalesceSignature(Type returnType, List<Type> argumentTypes) {
        return Signature.internalFunction(COALESCE, returnType.getName(), Lists.transform(argumentTypes, TypeUtils.nameGetter()));
    }
}

