/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SemiJoinNode
extends PlanNode {
    private final PlanNode source;
    private final PlanNode filteringSource;
    private final Symbol sourceJoinSymbol;
    private final Symbol filteringSourceJoinSymbol;
    private final Symbol semiJoinOutput;

    @JsonCreator
    public SemiJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="filteringSource") PlanNode filteringSource, @JsonProperty(value="sourceJoinSymbol") Symbol sourceJoinSymbol, @JsonProperty(value="filteringSourceJoinSymbol") Symbol filteringSourceJoinSymbol, @JsonProperty(value="semiJoinOutput") Symbol semiJoinOutput) {
        super(id);
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.filteringSource = (PlanNode)Preconditions.checkNotNull((Object)filteringSource, (Object)"filteringSource is null");
        this.sourceJoinSymbol = (Symbol)Preconditions.checkNotNull((Object)sourceJoinSymbol, (Object)"sourceJoinSymbol is null");
        this.filteringSourceJoinSymbol = (Symbol)Preconditions.checkNotNull((Object)filteringSourceJoinSymbol, (Object)"filteringSourceJoinSymbol is null");
        this.semiJoinOutput = (Symbol)Preconditions.checkNotNull((Object)semiJoinOutput, (Object)"semiJoinOutput is null");
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="filteringSource")
    public PlanNode getFilteringSource() {
        return this.filteringSource;
    }

    @JsonProperty(value="sourceJoinSymbol")
    public Symbol getSourceJoinSymbol() {
        return this.sourceJoinSymbol;
    }

    @JsonProperty(value="filteringSourceJoinSymbol")
    public Symbol getFilteringSourceJoinSymbol() {
        return this.filteringSourceJoinSymbol;
    }

    @JsonProperty(value="semiJoinOutput")
    public Symbol getSemiJoinOutput() {
        return this.semiJoinOutput;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source, (Object)this.filteringSource);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.semiJoinOutput).build();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitSemiJoin(this, context);
    }
}

