/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.PartitionResult;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.DomainUtils;
import com.facebook.presto.sql.planner.EffectivePredicateExtractor;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PredicatePushDown
extends PlanOptimizer {
    private static final Logger log = Logger.get(PredicatePushDown.class);
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;
    private final boolean experimentalSyntaxEnabled;

    public PredicatePushDown(Metadata metadata, SqlParser sqlParser, SplitManager splitManager, boolean experimentalSyntaxEnabled) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
        this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
        this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(symbolAllocator, idAllocator, this.metadata, this.sqlParser, this.splitManager, session, this.experimentalSyntaxEnabled), plan, BooleanLiteral.TRUE_LITERAL);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Expression> {
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final Session session;
        private final boolean experimentalSyntaxEnabled;

        private Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser, SplitManager splitManager, Session session, boolean experimentalSyntaxEnabled) {
            this.symbolAllocator = (SymbolAllocator)Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
            this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
            this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
            this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
            this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
            this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
        }

        @Override
        public PlanNode rewriteNode(PlanNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            PlanNode rewrittenNode = planRewriter.defaultRewrite(node, (Expression)BooleanLiteral.TRUE_LITERAL);
            if (!inheritedPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, inheritedPredicate);
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            Expression inlinedPredicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.getOutputMap()), (Expression)inheritedPredicate);
            return planRewriter.defaultRewrite(node, inlinedPredicate);
        }

        @Override
        public PlanNode rewriteMarkDistinct(MarkDistinctNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            Preconditions.checkState((!DependencyExtractor.extractUnique(inheritedPredicate).contains(node.getMarkerSymbol()) ? 1 : 0) != 0, (Object)"predicate depends on marker symbol");
            return planRewriter.defaultRewrite(node, inheritedPredicate);
        }

        @Override
        public PlanNode rewriteSort(SortNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            return planRewriter.defaultRewrite(node, inheritedPredicate);
        }

        @Override
        public PlanNode rewriteUnion(UnionNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression sourcePredicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.sourceSymbolMap(i)), (Expression)inheritedPredicate);
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = planRewriter.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List<PlanNode>)builder.build(), node.getSymbolMapping());
            }
            return node;
        }

        @Override
        public PlanNode rewriteFilter(FilterNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            return planRewriter.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(node.getPredicate(), inheritedPredicate));
        }

        @Override
        public PlanNode rewriteJoin(JoinNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            Expression rightPredicate;
            Expression leftPredicate;
            boolean isCrossJoin = node.getType() == JoinNode.Type.CROSS;
            node = this.tryNormalizeToInnerJoin(node, inheritedPredicate);
            Expression leftEffectivePredicate = EffectivePredicateExtractor.extract(node.getLeft(), this.symbolAllocator.getTypes());
            Expression rightEffectivePredicate = EffectivePredicateExtractor.extract(node.getRight(), this.symbolAllocator.getTypes());
            Expression joinPredicate = Rewriter.extractJoinPredicate(node);
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = joinPredicate;
                    break;
                }
                case RIGHT: {
                    OuterJoinPushDownResult rightOuterJoinPushDownResult = this.processOuterJoin(inheritedPredicate, rightEffectivePredicate, leftEffectivePredicate, joinPredicate, node.getRight().getOutputSymbols());
                    leftPredicate = rightOuterJoinPushDownResult.getInnerJoinPredicate();
                    rightPredicate = rightOuterJoinPushDownResult.getOuterJoinPredicate();
                    postJoinPredicate = rightOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = joinPredicate;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
                }
            }
            PlanNode leftSource = planRewriter.rewrite(node.getLeft(), leftPredicate);
            PlanNode rightSource = planRewriter.rewrite(node.getRight(), rightPredicate);
            PlanNode output = node;
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !newJoinPredicate.equals((Object)joinPredicate) || isCrossJoin) {
                ImmutableList criteria = node.getCriteria();
                if (!newJoinPredicate.equals((Object)joinPredicate) || isCrossJoin) {
                    ImmutableMap.Builder leftProjections = ImmutableMap.builder();
                    leftProjections.putAll(IterableTransformer.on(node.getLeft().getOutputSymbols()).toMap(ExpressionUtils.symbolToQualifiedNameReference()).map());
                    ImmutableMap.Builder rightProjections = ImmutableMap.builder();
                    rightProjections.putAll(IterableTransformer.on(node.getRight().getOutputSymbols()).toMap(ExpressionUtils.symbolToQualifiedNameReference()).map());
                    Iterable simplifiedJoinConjuncts = Iterables.transform(ExpressionUtils.extractConjuncts(newJoinPredicate), this.simplifyExpressions());
                    simplifiedJoinConjuncts = Iterables.filter((Iterable)simplifiedJoinConjuncts, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)BooleanLiteral.TRUE_LITERAL)));
                    if (Iterables.isEmpty((Iterable)simplifiedJoinConjuncts)) {
                        simplifiedJoinConjuncts = ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("0")));
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (Expression conjunct : simplifiedJoinConjuncts) {
                        Preconditions.checkState((boolean)Rewriter.joinEqualityExpression(node.getLeft().getOutputSymbols()).apply((Object)conjunct), (Object)"Expected join predicate to be a valid join equality");
                        ComparisonExpression equality = (ComparisonExpression)conjunct;
                        boolean alignedComparison = Iterables.all(DependencyExtractor.extractUnique(equality.getLeft()), (Predicate)Predicates.in(node.getLeft().getOutputSymbols()));
                        Expression leftExpression = alignedComparison ? equality.getLeft() : equality.getRight();
                        Expression rightExpression = alignedComparison ? equality.getRight() : equality.getLeft();
                        Symbol leftSymbol = this.symbolAllocator.newSymbol(leftExpression, this.extractType(leftExpression));
                        leftProjections.put((Object)leftSymbol, (Object)leftExpression);
                        Symbol rightSymbol = this.symbolAllocator.newSymbol(rightExpression, this.extractType(rightExpression));
                        rightProjections.put((Object)rightSymbol, (Object)rightExpression);
                        builder.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    }
                    leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, (Map<Symbol, Expression>)leftProjections.build());
                    rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, (Map<Symbol, Expression>)rightProjections.build());
                    criteria = builder.build();
                }
                output = new JoinNode(node.getId(), node.getType(), leftSource, rightSource, (List<JoinNode.EquiJoinClause>)criteria);
            }
            if (!postJoinPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postJoinPredicate);
            }
            return output;
        }

        private OuterJoinPushDownResult processOuterJoin(Expression inheritedPredicate, Expression outerEffectivePredicate, Expression innerEffectivePredicate, Expression joinPredicate, Collection<Symbol> outerSymbols) {
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(outerEffectivePredicate), (Predicate)Predicates.in(outerSymbols)), (Object)"outerEffectivePredicate must only contain symbols from outerSymbols");
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(innerEffectivePredicate), (Predicate)Predicates.not((Predicate)Predicates.in(outerSymbols))), (Object)"innerEffectivePredicate must not contain symbols from outerSymbols");
            ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
            postJoinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (Predicate)Predicates.not(DeterminismEvaluator.deterministic())));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            outerEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(outerEffectivePredicate);
            innerEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(innerEffectivePredicate);
            joinPredicate = ExpressionUtils.stripNonDeterministicConjuncts(joinPredicate);
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            EqualityInference outerInference = EqualityInference.createEqualityInference(inheritedPredicate, outerEffectivePredicate);
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.in(outerSymbols));
            Expression outerOnlyInheritedEqualities = ExpressionUtils.combineConjuncts(equalityPartition.getScopeEqualities());
            EqualityInference potentialNullSymbolInference = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
            EqualityInference potentialNullSymbolInferenceWithoutInnerInferred = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression outerRewritten = outerInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.in(outerSymbols));
                if (outerRewritten != null) {
                    outerPushdownConjuncts.add((Object)outerRewritten);
                    Expression innerRewritten = potentialNullSymbolInference.rewriteExpression(outerRewritten, (Predicate<Symbol>)Predicates.not((Predicate)Predicates.in(outerSymbols)));
                    if (innerRewritten == null) continue;
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                postJoinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(ExpressionUtils.and(outerEffectivePredicate, joinPredicate))) {
                Expression rewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.not((Predicate)Predicates.in(outerSymbols)));
                if (rewritten == null) continue;
                innerPushdownConjuncts.add((Object)rewritten);
            }
            outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.not((Predicate)Predicates.in(outerSymbols))).getScopeEqualities());
            return new OuterJoinPushDownResult(ExpressionUtils.combineConjuncts((Iterable<Expression>)outerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)innerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)postJoinConjuncts.build()));
        }

        private InnerJoinPushDownResult processInnerJoin(Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<Symbol> leftSymbols) {
            Expression rewritten;
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(leftEffectivePredicate), (Predicate)Predicates.in(leftSymbols)), (Object)"leftEffectivePredicate must only contain symbols from leftSymbols");
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(rightEffectivePredicate), (Predicate)Predicates.not((Predicate)Predicates.in(leftSymbols))), (Object)"rightEffectivePredicate must not contain symbols from leftSymbols");
            ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (Predicate)Predicates.not(DeterminismEvaluator.deterministic())));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(joinPredicate), (Predicate)Predicates.not(DeterminismEvaluator.deterministic())));
            joinPredicate = ExpressionUtils.stripNonDeterministicConjuncts(joinPredicate);
            leftEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(leftEffectivePredicate);
            rightEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(rightEffectivePredicate);
            EqualityInference allInference = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutLeftInferred = EqualityInference.createEqualityInference(inheritedPredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutRightInferred = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rightRewrittenConjunct;
                Expression leftRewrittenConjunct = allInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.in(leftSymbols));
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.not((Predicate)Predicates.in(leftSymbols)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct != null || rightRewrittenConjunct != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(rightEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.in(leftSymbols));
                if (rewritten == null) continue;
                leftPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(leftEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.not((Predicate)Predicates.in(leftSymbols)));
                if (rewritten == null) continue;
                rightPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(joinPredicate)) {
                Expression rightRewritten;
                Expression leftRewritten = allInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.in(leftSymbols));
                if (leftRewritten != null) {
                    leftPushDownConjuncts.add((Object)leftRewritten);
                }
                if ((rightRewritten = allInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.not((Predicate)Predicates.in(leftSymbols)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewritten);
                }
                if (leftRewritten != null || rightRewritten != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.in(leftSymbols)).getScopeEqualities());
            rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.not((Predicate)Predicates.in(leftSymbols))).getScopeEqualities());
            joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.in(leftSymbols)).getScopeStraddlingEqualities());
            ImmutableList joinConjunctsList = joinConjuncts.build();
            ImmutableList postJoinConjuncts = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)joinConjunctsList, (Predicate)Predicates.not(Rewriter.joinEqualityExpression(leftSymbols))));
            joinConjunctsList = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)joinConjunctsList, Rewriter.joinEqualityExpression(leftSymbols)));
            return new InnerJoinPushDownResult(ExpressionUtils.combineConjuncts((Iterable<Expression>)leftPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)rightPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Iterable<Expression>)joinConjunctsList), ExpressionUtils.combineConjuncts((Iterable<Expression>)postJoinConjuncts));
        }

        private static Expression extractJoinPredicate(JoinNode joinNode) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                builder.add((Object)Rewriter.equalsExpression(equiJoinClause.getLeft(), equiJoinClause.getRight()));
            }
            return ExpressionUtils.combineConjuncts((Iterable<Expression>)builder.build());
        }

        private static Expression equalsExpression(Symbol symbol1, Symbol symbol2) {
            return new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(symbol1.toQualifiedName()), (Expression)new QualifiedNameReference(symbol2.toQualifiedName()));
        }

        private Type extractType(Expression expression) {
            return ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression).get(expression);
        }

        private JoinNode tryNormalizeToInnerJoin(JoinNode node, Expression inheritedPredicate) {
            Preconditions.checkArgument((boolean)EnumSet.of(JoinNode.Type.INNER, JoinNode.Type.RIGHT, JoinNode.Type.LEFT, JoinNode.Type.CROSS).contains((Object)node.getType()), (String)"Unsupported join type: %s", (Object[])new Object[]{node.getType()});
            if (node.getType() == JoinNode.Type.CROSS) {
                return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria());
            }
            if (node.getType() == JoinNode.Type.INNER || node.getType() == JoinNode.Type.LEFT && !this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate) || node.getType() == JoinNode.Type.RIGHT && !this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate)) {
                return node;
            }
            return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria());
        }

        private boolean canConvertOuterToInner(List<Symbol> innerSymbolsForOuterJoin, Expression inheritedPredicate) {
            ImmutableSet innerSymbols = ImmutableSet.copyOf(innerSymbolsForOuterJoin);
            for (Expression conjunct : ExpressionUtils.extractConjuncts(inheritedPredicate)) {
                Object response;
                if (!DeterminismEvaluator.isDeterministic(conjunct) || (response = this.nullInputEvaluator((Collection<Symbol>)innerSymbols, conjunct)) != null && !(response instanceof NullLiteral) && !Boolean.FALSE.equals(response)) continue;
                return true;
            }
            return false;
        }

        private Function<Expression, Expression> simplifyExpressions() {
            return new Function<Expression, Expression>(){

                public Expression apply(Expression expression) {
                    IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(Rewriter.this.session, Rewriter.this.metadata, Rewriter.this.sqlParser, Rewriter.this.symbolAllocator.getTypes(), expression);
                    ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, Rewriter.this.metadata, Rewriter.this.session, expressionTypes);
                    return LiteralInterpreter.toExpression(optimizer.optimize(NoOpSymbolResolver.INSTANCE), expressionTypes.get(expression));
                }
            };
        }

        private Object nullInputEvaluator(final Collection<Symbol> nullSymbols, Expression expression) {
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression);
            return ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes).optimize(new SymbolResolver(){

                @Override
                public Object getValue(Symbol symbol) {
                    return nullSymbols.contains(symbol) ? null : new QualifiedNameReference(symbol.toQualifiedName());
                }
            });
        }

        private static Predicate<Expression> joinEqualityExpression(final Collection<Symbol> leftSymbols) {
            return new Predicate<Expression>(){

                public boolean apply(Expression expression) {
                    ComparisonExpression comparison;
                    if (DeterminismEvaluator.isDeterministic(expression) && expression instanceof ComparisonExpression && (comparison = (ComparisonExpression)expression).getType() == ComparisonExpression.Type.EQUAL) {
                        Set<Symbol> symbols1 = DependencyExtractor.extractUnique(comparison.getLeft());
                        Set<Symbol> symbols2 = DependencyExtractor.extractUnique(comparison.getRight());
                        return Iterables.all(symbols1, (Predicate)Predicates.in((Collection)leftSymbols)) && Iterables.all(symbols2, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)leftSymbols))) || Iterables.all(symbols2, (Predicate)Predicates.in((Collection)leftSymbols)) && Iterables.all(symbols1, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)leftSymbols)));
                    }
                    return false;
                }
            };
        }

        @Override
        public PlanNode rewriteSemiJoin(SemiJoinNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            Expression sourceEffectivePredicate = EffectivePredicateExtractor.extract(node.getSource(), this.symbolAllocator.getTypes());
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> filteringSourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            Expression joinPredicate = Rewriter.equalsExpression(node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol());
            EqualityInference joinInference = EqualityInference.createEqualityInference(inheritedPredicate, sourceEffectivePredicate, joinPredicate);
            for (Expression conjunct : Iterables.concat(EqualityInference.nonInferrableConjuncts(inheritedPredicate), EqualityInference.nonInferrableConjuncts(sourceEffectivePredicate))) {
                Expression rewrittenConjunct = joinInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol()));
                if (rewrittenConjunct == null || !DeterminismEvaluator.isDeterministic(rewrittenConjunct)) continue;
                Expression rewrittenConjunctOrNull = (Expression)ExpressionUtils.expressionOrNullSymbols((Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol())).apply((Object)rewrittenConjunct);
                filteringSourceConjuncts.add(rewrittenConjunctOrNull);
            }
            EqualityInference.EqualityPartition joinInferenceEqualityPartition = joinInference.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol()));
            filteringSourceConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.transform(joinInferenceEqualityPartition.getScopeEqualities(), ExpressionUtils.expressionOrNullSymbols((Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol())))));
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = inheritedInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.in(node.getSource().getOutputSymbols()));
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.in(node.getSource().getOutputSymbols()));
            sourceConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = planRewriter.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(sourceConjuncts));
            PlanNode rewrittenFilteringSource = planRewriter.rewrite(node.getFilteringSource(), ExpressionUtils.combineConjuncts(filteringSourceConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postJoinConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            EqualityInference equalityInference = EqualityInference.createEqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postAggregationConjuncts = new ArrayList<Expression>();
            postAggregationConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (Predicate)Predicates.not(DeterminismEvaluator.deterministic()))));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.in(node.getGroupBy()));
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postAggregationConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.in(node.getGroupBy()));
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = planRewriter.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new AggregationNode(node.getId(), rewrittenSource, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getStep(), node.getSampleWeight(), node.getConfidence());
            }
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postAggregationConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode rewriteSample(SampleNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            return planRewriter.defaultRewrite(node, inheritedPredicate);
        }

        @Override
        public PlanNode rewriteTableScan(TableScanNode node, Expression inheritedPredicate, PlanRewriter<Expression> planRewriter) {
            DomainTranslator.ExtractionResult extractionResult = DomainTranslator.fromPredicate(this.metadata, this.session, inheritedPredicate, this.symbolAllocator.getTypes(), node.getAssignments());
            Expression extractionRemainingExpression = extractionResult.getRemainingExpression();
            TupleDomain tupleDomain = extractionResult.getTupleDomain();
            if (node.getGeneratedPartitions().isPresent()) {
                tupleDomain = tupleDomain.intersect(((TableScanNode.GeneratedPartitions)node.getGeneratedPartitions().get()).getTupleDomainInput()).intersect(node.getPartitionsDomainSummary());
            }
            PartitionResult matchingPartitions = this.splitManager.getPartitions(node.getTable(), (Optional<TupleDomain<ColumnHandle>>)Optional.of(tupleDomain));
            ImmutableList partitions = matchingPartitions.getPartitions();
            TupleDomain<ColumnHandle> undeterminedTupleDomain = matchingPartitions.getUndeterminedTupleDomain();
            Expression unevaluatedDomainPredicate = DomainTranslator.toPredicate(undeterminedTupleDomain, (Map<ColumnHandle, Symbol>)ImmutableBiMap.copyOf(node.getAssignments()).inverse(), this.symbolAllocator.getTypes());
            Expression postScanPredicate = ExpressionUtils.combineConjuncts(unevaluatedDomainPredicate, extractionRemainingExpression);
            partitions = ImmutableList.copyOf((Iterable)Iterables.filter(partitions, (Predicate)Predicates.not(this.shouldPrunePartition(postScanPredicate, node.getAssignments()))));
            TableScanNode.GeneratedPartitions generatedPartitions = new TableScanNode.GeneratedPartitions((TupleDomain<ColumnHandle>)tupleDomain, (List<Partition>)partitions);
            PlanNode output = node;
            if (!node.getGeneratedPartitions().equals((Object)Optional.of((Object)generatedPartitions))) {
                Expression originalConstraint = node.getOriginalConstraint() == null ? inheritedPredicate : node.getOriginalConstraint();
                output = new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), originalConstraint, (Optional<TableScanNode.GeneratedPartitions>)Optional.of((Object)generatedPartitions));
            }
            if (!postScanPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postScanPredicate);
            }
            return output;
        }

        private Predicate<Partition> shouldPrunePartition(final Expression predicate, final Map<Symbol, ColumnHandle> symbolToColumn) {
            return new Predicate<Partition>(){

                public boolean apply(Partition partition) {
                    Map columnFixedValueAssignments = partition.getTupleDomain().extractFixedValues();
                    Map translatableAssignments = Maps.filterKeys((Map)columnFixedValueAssignments, (Predicate)Predicates.in(symbolToColumn.values()));
                    Map symbolFixedValueAssignments = DomainUtils.columnHandleToSymbol(translatableAssignments, symbolToColumn);
                    LookupSymbolResolver inputs = new LookupSymbolResolver((Map<Symbol, Object>)ImmutableMap.copyOf(symbolFixedValueAssignments));
                    for (Expression expression : ExpressionUtils.extractConjuncts(predicate)) {
                        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(Rewriter.this.session, Rewriter.this.metadata, Rewriter.this.sqlParser, Rewriter.this.symbolAllocator.getTypes(), expression);
                        ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, Rewriter.this.metadata, Rewriter.this.session, expressionTypes);
                        Object optimized = optimizer.optimize(inputs);
                        if (!Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private static class InnerJoinPushDownResult {
            private final Expression leftPredicate;
            private final Expression rightPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.leftPredicate = leftPredicate;
                this.rightPredicate = rightPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getLeftPredicate() {
                return this.leftPredicate;
            }

            private Expression getRightPredicate() {
                return this.rightPredicate;
            }

            private Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class OuterJoinPushDownResult {
            private final Expression outerJoinPredicate;
            private final Expression innerJoinPredicate;
            private final Expression postJoinPredicate;

            private OuterJoinPushDownResult(Expression outerJoinPredicate, Expression innerJoinPredicate, Expression postJoinPredicate) {
                this.outerJoinPredicate = outerJoinPredicate;
                this.innerJoinPredicate = innerJoinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getOuterJoinPredicate() {
                return this.outerJoinPredicate;
            }

            private Expression getInnerJoinPredicate() {
                return this.innerJoinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }
    }
}

