/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.EquiJoinClause;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
        Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery = this.analysis.getNamedQuery(node);
        if (namedQuery != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), subPlan.getOutputSymbols(), subPlan.getSampleWeight());
        }
        TupleDescriptor descriptor = this.analysis.getOutputDescriptor((Node)node);
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (Field field : descriptor.getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol((String)field.getName().get(), field.getType());
            outputSymbolsBuilder.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
        }
        ImmutableList planOutputSymbols = outputSymbolsBuilder.build();
        Optional<ColumnHandle> sampleWeightColumn = this.metadata.getSampleWeightColumnHandle(handle);
        Symbol sampleWeightSymbol = null;
        if (sampleWeightColumn.isPresent()) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
            outputSymbolsBuilder.add((Object)sampleWeightSymbol);
            columns.put((Object)sampleWeightSymbol, sampleWeightColumn.get());
        }
        ImmutableList nodeOutputSymbols = outputSymbolsBuilder.build();
        TableScanNode root = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)nodeOutputSymbols, (Map<Symbol, ColumnHandle>)columns.build(), null, (Optional<TableScanNode.GeneratedPartitions>)Optional.absent());
        return new RelationPlan(root, descriptor, (List<Symbol>)planOutputSymbols, (Optional<Symbol>)Optional.fromNullable((Object)sampleWeightSymbol));
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        TupleDescriptor outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        return new RelationPlan(subPlan.getRoot(), outputDescriptor, subPlan.getOutputSymbols(), subPlan.getSampleWeight());
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        if (node.getColumnsToStratifyOn().isPresent()) {
            throw new UnsupportedOperationException("STRATIFY ON is not yet implemented");
        }
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        TupleDescriptor outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        double ratio = this.analysis.getSampleRatio(node);
        Symbol sampleWeightSymbol = null;
        if (node.getType() == SampledRelation.Type.POISSONIZED) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
        }
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNode.Type.fromType(node.getType()), node.isRescaled(), (Optional<Symbol>)Optional.fromNullable((Object)sampleWeightSymbol));
        return new RelationPlan(planNode, outputDescriptor, subPlan.getOutputSymbols(), (Optional<Symbol>)Optional.fromNullable((Object)sampleWeightSymbol));
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
        RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        TupleDescriptor outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getOutputSymbols()).addAll(rightPlan.getOutputSymbols()).build();
        ImmutableList.Builder clauses = ImmutableList.builder();
        if (node.getType() != Join.Type.CROSS) {
            List<EquiJoinClause> criteria = this.analysis.getJoinCriteria(node);
            Analysis.JoinInPredicates joinInPredicates = this.analysis.getJoinInPredicates(node);
            if (joinInPredicates != null) {
                leftPlanBuilder = this.appendSemiJoins(leftPlanBuilder, joinInPredicates.getLeftInPredicates());
                rightPlanBuilder = this.appendSemiJoins(rightPlanBuilder, joinInPredicates.getRightInPredicates());
            }
            leftPlanBuilder = this.appendProjections(leftPlanBuilder, Iterables.transform(criteria, EquiJoinClause.leftGetter()));
            rightPlanBuilder = this.appendProjections(rightPlanBuilder, Iterables.transform(criteria, EquiJoinClause.rightGetter()));
            for (EquiJoinClause clause : criteria) {
                Symbol leftSymbol = leftPlanBuilder.translate(clause.getLeft());
                Symbol rightSymbol = rightPlanBuilder.translate(clause.getRight());
                clauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
            }
        }
        PlanNode root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)clauses.build());
        Optional sampleWeight = Optional.absent();
        if (leftPlanBuilder.getSampleWeight().isPresent() || rightPlanBuilder.getSampleWeight().isPresent()) {
            ArithmeticExpression expression = new ArithmeticExpression(ArithmeticExpression.Type.MULTIPLY, this.oneIfNull(leftPlanBuilder.getSampleWeight()), this.oneIfNull(rightPlanBuilder.getSampleWeight()));
            sampleWeight = Optional.of((Object)this.symbolAllocator.newSymbol((Expression)expression, (Type)BigintType.BIGINT));
            root = new ProjectNode(this.idAllocator.getNextId(), root, (Map<Symbol, Expression>)ImmutableMap.of((Object)sampleWeight.get(), (Object)expression));
        }
        return new RelationPlan(root, outputDescriptor, (List<Symbol>)outputSymbols, (Optional<Symbol>)sampleWeight);
    }

    private Expression oneIfNull(Optional<Symbol> symbol) {
        if (symbol.isPresent()) {
            return new CoalesceExpression(new Expression[]{new QualifiedNameReference(((Symbol)symbol.get()).toQualifiedName()), new LongLiteral("1")});
        }
        return new LongLiteral("1");
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build(), subPlan.getSampleWeight());
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build(), subPlan.getSampleWeight());
    }

    protected RelationPlan visitValues(Values node, Void context) {
        TupleDescriptor descriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : descriptor.getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Row row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            for (Expression expression : row.getItems()) {
                values.add((Object)this.evaluateConstantExpression(expression));
            }
            rows.add((Object)values.build());
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbolsBuilder.build(), (List<List<Expression>>)rows.build());
        return new RelationPlan(valuesNode, descriptor, (List<Symbol>)outputSymbolsBuilder.build(), (Optional<Symbol>)Optional.absent());
    }

    private Expression evaluateConstantExpression(final Expression expression) {
        try {
            Expression canonicalized = CanonicalizeExpressions.canonicalizeExpression(expression);
            ExpressionInterpreter.expressionOptimizer(canonicalized, this.metadata, this.session, this.analysis.getTypes()).optimize(new SymbolResolver(){

                @Override
                public Object getValue(Symbol symbol) {
                    throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)expression, "Constant expression cannot contain column references", new Object[0]);
                }
            });
            Object result = ExpressionInterpreter.expressionInterpreter(canonicalized, this.metadata, this.session, this.analysis.getTypes()).evaluate(0, new Block[0]);
            Preconditions.checkState((!(result instanceof Expression) ? 1 : 0) != 0, (Object)"Expression interpreter returned an unresolved expression");
            return LiteralInterpreter.toExpression(result, this.analysis.getType(expression));
        }
        catch (Exception e) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)expression, "Error evaluating constant expression: %s", e.getMessage());
        }
    }

    protected RelationPlan visitUnion(Union node, final Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        List unionOutputSymbols = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        List<RelationPlan> subPlans = IterableTransformer.on(node.getRelations()).transform(new Function<Relation, RelationPlan>(){

            public RelationPlan apply(Relation relation) {
                return (RelationPlan)RelationPlanner.this.process((Node)relation, context);
            }
        }).list();
        boolean hasSampleWeight = false;
        for (RelationPlan subPlan : subPlans) {
            if (!subPlan.getSampleWeight().isPresent()) continue;
            hasSampleWeight = true;
            break;
        }
        Optional<Symbol> outputSampleWeight = Optional.absent();
        for (RelationPlan relationPlan : subPlans) {
            int fieldIndex;
            TupleDescriptor descriptor;
            if (hasSampleWeight && !relationPlan.getSampleWeight().isPresent()) {
                relationPlan = this.addConstantSampleWeight(relationPlan);
            }
            List<Symbol> childOutputSymobls = relationPlan.getOutputSymbols();
            if (unionOutputSymbols == null) {
                descriptor = relationPlan.getDescriptor();
                ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
                for (Field field : descriptor.getVisibleFields()) {
                    fieldIndex = descriptor.indexOf(field);
                    Symbol symbol = childOutputSymobls.get(fieldIndex);
                    outputSymbolBuilder.add((Object)this.symbolAllocator.newSymbol(symbol.getName(), this.symbolAllocator.getTypes().get(symbol)));
                }
                unionOutputSymbols = outputSymbolBuilder.build();
                outputSampleWeight = relationPlan.getSampleWeight();
            }
            Preconditions.checkArgument(((descriptor = relationPlan.getDescriptor()).getVisibleFieldCount() == unionOutputSymbols.size() ? 1 : 0) != 0, (String)"Expected relation to have %s symbols but has %s symbols", (Object[])new Object[]{descriptor.getVisibleFieldCount(), unionOutputSymbols.size()});
            int unionFieldId = 0;
            for (Field field : descriptor.getVisibleFields()) {
                fieldIndex = descriptor.indexOf(field);
                symbolMapping.put(unionOutputSymbols.get(unionFieldId), (Object)childOutputSymobls.get(fieldIndex));
                ++unionFieldId;
            }
            sources.add((Object)relationPlan.getRoot());
        }
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), (List<PlanNode>)sources.build(), (ListMultimap<Symbol, Symbol>)symbolMapping.build());
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getOutputDescriptor((Node)node), planNode.getOutputSymbols(), outputSampleWeight);
    }

    private RelationPlan addConstantSampleWeight(RelationPlan subPlan) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getOutputSymbols()) {
            QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)expression);
        }
        LongLiteral one = new LongLiteral("1");
        Symbol sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", (Type)BigintType.BIGINT);
        projections.put((Object)sampleWeightSymbol, (Object)one);
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build());
        return new RelationPlan(projectNode, subPlan.getDescriptor(), projectNode.getOutputSymbols(), (Optional<Symbol>)Optional.of((Object)sampleWeightSymbol));
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
    }

    private PlanBuilder appendProjections(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getRoot().getOutputSymbols()) {
            QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)qualifiedNameReference);
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            projections.put((Object)symbol, (Object)translations.rewrite(expression));
            newTranslations.put((Object)symbol, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private PlanBuilder appendSemiJoins(PlanBuilder subPlan, Set<InPredicate> inPredicates) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendSemiJoin(subPlan, inPredicate);
        }
        return subPlan;
    }

    private PlanBuilder appendSemiJoin(PlanBuilder subPlan, InPredicate inPredicate) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        subPlan = this.appendProjections(subPlan, (Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()));
        Symbol sourceJoinSymbol = subPlan.translate(inPredicate.getValue());
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression subqueryExpression = (SubqueryExpression)inPredicate.getValueList();
        RelationPlanner relationPlanner = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        RelationPlan valueListRelation = (RelationPlan)relationPlanner.process((Node)subqueryExpression.getQuery(), null);
        Symbol filteringSourceJoinSymbol = (Symbol)Iterables.getOnlyElement(valueListRelation.getRoot().getOutputSymbols());
        Symbol semiJoinOutputSymbol = this.symbolAllocator.newSymbol("semijoinresult", (Type)BooleanType.BOOLEAN);
        translations.put((Expression)inPredicate, semiJoinOutputSymbol);
        return new PlanBuilder(translations, new SemiJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), valueListRelation.getRoot(), sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutputSymbol), subPlan.getSampleWeight());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, node.getOutputSymbols(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), (Optional<Symbol>)Optional.absent(), 1.0);
    }
}

