/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.joni.Regex;

public class ExpressionInterpreter {
    private final Expression expression;
    private final Metadata metadata;
    private final ConnectorSession session;
    private final boolean optimize;
    private final IdentityHashMap<Expression, Type> expressionTypes;
    private final Visitor visitor;
    private final IdentityHashMap<LikePredicate, Regex> likePatternCache = new IdentityHashMap();
    private final IdentityHashMap<InListExpression, Set<Object>> inListCache = new IdentityHashMap();

    public static ExpressionInterpreter expressionInterpreter(Expression expression, Metadata metadata, Session session, IdentityHashMap<Expression, Type> expressionTypes) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        return new ExpressionInterpreter(expression, metadata, session, expressionTypes, false);
    }

    public static ExpressionInterpreter expressionOptimizer(Expression expression, Metadata metadata, Session session, IdentityHashMap<Expression, Type> expressionTypes) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        return new ExpressionInterpreter(expression, metadata, session, expressionTypes, true);
    }

    private ExpressionInterpreter(Expression expression, Metadata metadata, Session session, IdentityHashMap<Expression, Type> expressionTypes, boolean optimize) {
        this.expression = expression;
        this.metadata = metadata;
        this.session = session.toConnectorSession();
        this.expressionTypes = expressionTypes;
        this.optimize = optimize;
        this.visitor = new Visitor();
    }

    public Object evaluate(RecordCursor inputs) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(RecordCursor) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, inputs);
    }

    public Object evaluate(int position, Block ... inputs) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(int, Block...) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, new PagePositionContext(position, inputs));
    }

    public Object optimize(SymbolResolver inputs) {
        Preconditions.checkState((boolean)this.optimize, (Object)"evaluate(SymbolResolver) not allowed for interpreter");
        return this.visitor.process((Node)this.expression, inputs);
    }

    public static Object invoke(ConnectorSession session, MethodHandle handle, List<Object> argumentValues) {
        if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == ConnectorSession.class) {
            handle = handle.bindTo(session);
        }
        try {
            return handle.invokeWithArguments(argumentValues);
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    private static Predicate<Expression> isNonNullLiteralPredicate() {
        return new Predicate<Expression>(){

            public boolean apply(@Nullable Expression input) {
                return input instanceof Literal && !(input instanceof NullLiteral);
            }
        };
    }

    private static class PagePositionContext {
        private final int position;
        private final Block[] blocks;

        private PagePositionContext(int position, Block[] blocks) {
            this.position = position;
            this.blocks = blocks;
        }

        public Block getBlock(int channel) {
            return this.blocks[channel];
        }

        public int getPosition() {
            return this.position;
        }
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        private Visitor() {
        }

        public Object visitInputReference(InputReference node, Object context) {
            Type type = (Type)ExpressionInterpreter.this.expressionTypes.get(node);
            int channel = node.getChannel();
            if (context instanceof PagePositionContext) {
                PagePositionContext pagePositionContext = (PagePositionContext)context;
                int position = pagePositionContext.getPosition();
                Block block = pagePositionContext.getBlock(channel);
                if (block.isNull(position)) {
                    return null;
                }
                Class javaType = type.getJavaType();
                if (javaType == Boolean.TYPE) {
                    return type.getBoolean(block, position);
                }
                if (javaType == Long.TYPE) {
                    return type.getLong(block, position);
                }
                if (javaType == Double.TYPE) {
                    return type.getDouble(block, position);
                }
                if (javaType == Slice.class) {
                    return type.getSlice(block, position);
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
            if (context instanceof RecordCursor) {
                RecordCursor cursor = (RecordCursor)context;
                if (cursor.isNull(channel)) {
                    return null;
                }
                Class javaType = type.getJavaType();
                if (javaType == Boolean.TYPE) {
                    return cursor.getBoolean(channel);
                }
                if (javaType == Long.TYPE) {
                    return cursor.getLong(channel);
                }
                if (javaType == Double.TYPE) {
                    return cursor.getDouble(channel);
                }
                if (javaType == Slice.class) {
                    return cursor.getSlice(channel);
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
            throw new UnsupportedOperationException("Inputs or cursor myst be set");
        }

        protected Object visitQualifiedNameReference(QualifiedNameReference node, Object context) {
            if (node.getName().getPrefix().isPresent()) {
                return node;
            }
            Symbol symbol = Symbol.fromQualifiedName(node.getName());
            return ((SymbolResolver)context).getValue(symbol);
        }

        protected Object visitLiteral(Literal node, Object context) {
            return LiteralInterpreter.evaluate(ExpressionInterpreter.this.metadata, ExpressionInterpreter.this.session, (Expression)node);
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNullPredicate(LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue())));
            }
            return value == null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNotNullPredicate(LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue())));
            }
            return value != null;
        }

        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Expression resultClause = node.getDefaultValue();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object value = this.process((Node)whenClause.getOperand(), context);
                if (value instanceof Expression) {
                    return node;
                }
                if (!Boolean.TRUE.equals(value)) continue;
                resultClause = whenClause.getResult();
                break;
            }
            if (resultClause == null) {
                return null;
            }
            Object result = this.process((Node)resultClause, context);
            if (result instanceof Expression) {
                return node;
            }
            return result;
        }

        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.process((Node)node.getOperand(), context);
            if (operand instanceof Expression) {
                return node;
            }
            Expression resultClause = node.getDefaultValue();
            if (operand != null) {
                for (WhenClause whenClause : node.getWhenClauses()) {
                    Object value = this.process((Node)whenClause.getOperand(), context);
                    if (value == null) continue;
                    if (value instanceof Expression) {
                        return node;
                    }
                    if (!((Boolean)this.invokeOperator(OperatorType.EQUAL, this.types(node.getOperand(), whenClause.getOperand()), (List<Object>)ImmutableList.of((Object)operand, (Object)value))).booleanValue()) continue;
                    resultClause = whenClause.getResult();
                    break;
                }
            }
            if (resultClause == null) {
                return null;
            }
            Object result = this.process((Node)resultClause, context);
            if (result instanceof Expression) {
                return node;
            }
            return result;
        }

        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            for (Expression expression : node.getOperands()) {
                Object value = this.process((Node)expression, context);
                if (value instanceof Expression) {
                    return node;
                }
                if (value == null) continue;
                return value;
            }
            return null;
        }

        protected Object visitInPredicate(InPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            Expression valueListExpression = node.getValueList();
            if (!(valueListExpression instanceof InListExpression)) {
                if (!ExpressionInterpreter.this.optimize) {
                    throw new UnsupportedOperationException("IN predicate value list type not yet implemented: " + valueListExpression.getClass().getName());
                }
                return node;
            }
            InListExpression valueList = (InListExpression)valueListExpression;
            HashSet<Object> set = (HashSet<Object>)ExpressionInterpreter.this.inListCache.get(valueList);
            if (!ExpressionInterpreter.this.inListCache.containsKey(valueList)) {
                if (Iterables.all((Iterable)valueList.getValues(), (Predicate)ExpressionInterpreter.isNonNullLiteralPredicate())) {
                    set = new HashSet<Object>();
                    for (Expression expression : valueList.getValues()) {
                        set.add(this.process((Node)expression, context));
                    }
                }
                ExpressionInterpreter.this.inListCache.put(valueList, set);
            }
            if (set != null && !(value instanceof Expression)) {
                return set.contains(value);
            }
            boolean hasUnresolvedValue = false;
            if (value instanceof Expression) {
                hasUnresolvedValue = true;
            }
            boolean hasNullValue = false;
            boolean found = false;
            ArrayList<Object> values = new ArrayList<Object>(valueList.getValues().size());
            ArrayList types = new ArrayList(valueList.getValues().size());
            for (Expression expression : valueList.getValues()) {
                Object inValue = this.process((Node)expression, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    types.add(ExpressionInterpreter.this.expressionTypes.get(expression));
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !((Boolean)this.invokeOperator(OperatorType.EQUAL, this.types(node.getValue(), expression), (List<Object>)ImmutableList.of((Object)value, (Object)inValue))).booleanValue()) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                Type type = (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue());
                return new InPredicate(LiteralInterpreter.toExpression(value, type), (Expression)new InListExpression(LiteralInterpreter.toExpressions(values, types)));
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        protected Object visitNegativeExpression(NegativeExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NegativeExpression(LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue())));
            }
            FunctionInfo operatorInfo = ExpressionInterpreter.this.metadata.resolveOperator(OperatorType.NEGATION, this.types(node.getValue()));
            MethodHandle handle = operatorInfo.getMethodHandle();
            if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == ConnectorSession.class) {
                handle = handle.bindTo(ExpressionInterpreter.this.session);
            }
            try {
                return handle.invokeWithArguments(value);
            }
            catch (Throwable throwable) {
                Throwables.propagateIfInstanceOf((Throwable)throwable, RuntimeException.class);
                Throwables.propagateIfInstanceOf((Throwable)throwable, Error.class);
                throw new RuntimeException(throwable.getMessage(), throwable);
            }
        }

        protected Object visitArithmeticExpression(ArithmeticExpression node, Object context) {
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ArithmeticExpression(node.getType(), LiteralInterpreter.toExpression(left, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getLeft())), LiteralInterpreter.toExpression(right, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getRight())));
            }
            return this.invokeOperator(OperatorType.valueOf(node.getType().name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            ComparisonExpression.Type type = node.getType();
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null && type != ComparisonExpression.Type.IS_DISTINCT_FROM) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (type == ComparisonExpression.Type.IS_DISTINCT_FROM) {
                if (left == null && right == null) {
                    return false;
                }
                if (left == null || right == null) {
                    return true;
                }
            } else if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ComparisonExpression(type, LiteralInterpreter.toExpression(left, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getLeft())), LiteralInterpreter.toExpression(right, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getRight())));
            }
            if (type == ComparisonExpression.Type.IS_DISTINCT_FROM) {
                type = ComparisonExpression.Type.NOT_EQUAL;
            }
            return this.invokeOperator(OperatorType.valueOf(type.name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.process((Node)node.getMin(), context);
            if (min == null) {
                return null;
            }
            Object max = this.process((Node)node.getMax(), context);
            if (max == null) {
                return null;
            }
            if (this.hasUnresolvedValue(value, min, max)) {
                return new BetweenPredicate(LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue())), LiteralInterpreter.toExpression(min, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getMin())), LiteralInterpreter.toExpression(max, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getMax())));
            }
            return this.invokeOperator(OperatorType.BETWEEN, this.types(node.getValue(), node.getMin(), node.getMax()), (List<Object>)ImmutableList.of((Object)value, (Object)min, (Object)max));
        }

        protected Object visitNullIfExpression(NullIfExpression node, Object context) {
            Object first = this.process((Node)node.getFirst(), context);
            if (first == null) {
                return null;
            }
            Object second = this.process((Node)node.getSecond(), context);
            if (second == null) {
                return first;
            }
            Type firstType = (Type)ExpressionInterpreter.this.expressionTypes.get(node.getFirst());
            Type secondType = (Type)ExpressionInterpreter.this.expressionTypes.get(node.getSecond());
            if (this.hasUnresolvedValue(first, second)) {
                return new NullIfExpression(LiteralInterpreter.toExpression(first, firstType), LiteralInterpreter.toExpression(second, secondType));
            }
            Type commonType = (Type)FunctionRegistry.getCommonSuperType(firstType, secondType).get();
            FunctionInfo firstCast = ExpressionInterpreter.this.metadata.getFunctionRegistry().getCoercion(firstType, commonType);
            FunctionInfo secondCast = ExpressionInterpreter.this.metadata.getFunctionRegistry().getCoercion(secondType, commonType);
            boolean equal = (Boolean)this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)ExpressionInterpreter.invoke(ExpressionInterpreter.this.session, firstCast.getMethodHandle(), (List<Object>)ImmutableList.of((Object)first)), (Object)ExpressionInterpreter.invoke(ExpressionInterpreter.this.session, secondCast.getMethodHandle(), (List<Object>)ImmutableList.of((Object)second))));
            if (equal) {
                return null;
            }
            return first;
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NotExpression(LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue())));
            }
            return (Boolean)value == false;
        }

        protected Object visitLogicalBinaryExpression(LogicalBinaryExpression node, Object context) {
            Object left = this.process((Node)node.getLeft(), context);
            Object right = this.process((Node)node.getRight(), context);
            switch (node.getType()) {
                case AND: {
                    if (Boolean.FALSE.equals(left) || Boolean.TRUE.equals(right)) {
                        return left;
                    }
                    if (Boolean.FALSE.equals(right) || Boolean.TRUE.equals(left)) {
                        return right;
                    }
                }
                case OR: {
                    if (Boolean.TRUE.equals(left) || Boolean.FALSE.equals(right)) {
                        return left;
                    }
                    if (!Boolean.TRUE.equals(right) && !Boolean.FALSE.equals(left)) break;
                    return right;
                }
            }
            if (left == null && right == null) {
                return null;
            }
            return new LogicalBinaryExpression(node.getType(), LiteralInterpreter.toExpression(left, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getLeft())), LiteralInterpreter.toExpression(right, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getRight())));
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Object context) {
            return node.equals((Object)BooleanLiteral.TRUE_LITERAL);
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            Object value;
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expression : node.getArguments()) {
                value = this.process((Node)expression, context);
                Type type = (Type)ExpressionInterpreter.this.expressionTypes.get(expression);
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            FunctionInfo function = ExpressionInterpreter.this.metadata.resolveFunction(node.getName(), Lists.transform(argumentTypes, TypeUtils.nameGetter()), false);
            for (int i = 0; i < argumentValues.size(); ++i) {
                value = argumentValues.get(i);
                if (value != null || function.getNullableArguments().get(i).booleanValue()) continue;
                return null;
            }
            if (ExpressionInterpreter.this.optimize && (!function.isDeterministic() || this.hasUnresolvedValue(argumentValues))) {
                return new FunctionCall(node.getName(), (Window)node.getWindow().orNull(), node.isDistinct(), LiteralInterpreter.toExpressions(argumentValues, argumentTypes));
            }
            return ExpressionInterpreter.invoke(ExpressionInterpreter.this.session, function.getMethodHandle(), argumentValues);
        }

        protected Object visitLikePredicate(LikePredicate node, Object context) {
            String stringPattern;
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Slice && node.getPattern() instanceof StringLiteral && (node.getEscape() instanceof StringLiteral || node.getEscape() == null)) {
                return LikeFunctions.like((Slice)value, this.getConstantPattern(node));
            }
            Object pattern = this.process((Node)node.getPattern(), context);
            if (pattern == null) {
                return null;
            }
            Object escape = null;
            if (node.getEscape() != null && (escape = this.process((Node)node.getEscape(), context)) == null) {
                return null;
            }
            if (value instanceof Slice && pattern instanceof Slice && (escape == null || escape instanceof Slice)) {
                Regex regex = escape == null ? LikeFunctions.likePattern((Slice)pattern) : LikeFunctions.likePattern((Slice)pattern, (Slice)escape);
                return LikeFunctions.like((Slice)value, regex);
            }
            if (pattern instanceof Slice && escape == null && !(stringPattern = ((Slice)pattern).toString(Charsets.UTF_8)).contains("%") && !stringPattern.contains("_")) {
                return new ComparisonExpression(ComparisonExpression.Type.EQUAL, LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue())), LiteralInterpreter.toExpression(pattern, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getPattern())));
            }
            Expression optimizedEscape = null;
            if (node.getEscape() != null) {
                optimizedEscape = LiteralInterpreter.toExpression(escape, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getEscape()));
            }
            return new LikePredicate(LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getValue())), LiteralInterpreter.toExpression(pattern, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getPattern())), optimizedEscape);
        }

        private Regex getConstantPattern(LikePredicate node) {
            Regex result = (Regex)ExpressionInterpreter.this.likePatternCache.get(node);
            if (result == null) {
                StringLiteral pattern = (StringLiteral)node.getPattern();
                StringLiteral escape = (StringLiteral)node.getEscape();
                result = escape == null ? LikeFunctions.likePattern(pattern.getSlice()) : LikeFunctions.likePattern(pattern.getSlice(), escape.getSlice());
                ExpressionInterpreter.this.likePatternCache.put(node, result);
            }
            return result;
        }

        public Object visitCast(Cast node, Object context) {
            Object value = this.process((Node)node.getExpression(), context);
            if (value instanceof Expression) {
                return new Cast((Expression)value, node.getType(), node.isSafe());
            }
            if (ExpressionInterpreter.this.optimize && !FunctionRegistry.isSupportedLiteralType((Type)ExpressionInterpreter.this.expressionTypes.get(node))) {
                return new Cast(LiteralInterpreter.toExpression(value, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getExpression())), node.getType(), node.isSafe());
            }
            if (value == null) {
                return null;
            }
            Type type = ExpressionInterpreter.this.metadata.getType(node.getType());
            if (type == null) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            FunctionInfo operatorInfo = ExpressionInterpreter.this.metadata.getFunctionRegistry().getCoercion((Type)ExpressionInterpreter.this.expressionTypes.get(node.getExpression()), type);
            try {
                return ExpressionInterpreter.invoke(ExpressionInterpreter.this.session, operatorInfo.getMethodHandle(), (List<Object>)ImmutableList.of((Object)value));
            }
            catch (RuntimeException e) {
                if (node.isSafe()) {
                    return null;
                }
                throw e;
            }
        }

        protected Object visitArrayConstructor(ArrayConstructor node, Object context) {
            return this.visitFunctionCall(new FunctionCall(QualifiedName.of((String)"ARRAY_CONSTRUCTOR", (String[])new String[0]), node.getValues()), context);
        }

        protected Object visitSubscriptExpression(SubscriptExpression node, Object context) {
            Object base = this.process((Node)node.getBase(), context);
            if (base == null) {
                return null;
            }
            Object index = this.process((Node)node.getIndex(), context);
            if (index == null) {
                return null;
            }
            if (this.hasUnresolvedValue(base, index)) {
                return new SubscriptExpression(LiteralInterpreter.toExpression(base, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getBase())), LiteralInterpreter.toExpression(index, (Type)ExpressionInterpreter.this.expressionTypes.get(node.getIndex())));
            }
            return this.invokeOperator(OperatorType.SUBSCRIPT, this.types(node.getBase(), node.getIndex()), (List<Object>)ImmutableList.of((Object)base, (Object)index));
        }

        protected Object visitExpression(Expression node, Object context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        protected Object visitNode(Node node, Object context) {
            throw new UnsupportedOperationException("Evaluator visitor can only handle Expression nodes");
        }

        private List<Type> types(Expression ... types) {
            return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf((Object[])types), (Function)Functions.forMap((Map)ExpressionInterpreter.this.expressionTypes)));
        }

        private boolean hasUnresolvedValue(Object ... values) {
            return this.hasUnresolvedValue((List<Object>)ImmutableList.copyOf((Object[])values));
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return Iterables.any(values, (Predicate)Predicates.instanceOf(Expression.class));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            FunctionInfo operatorInfo = ExpressionInterpreter.this.metadata.resolveOperator(operatorType, argumentTypes);
            return ExpressionInterpreter.invoke(ExpressionInterpreter.this.session, operatorInfo.getMethodHandle(), argumentValues);
        }

        private Object optimize(Node node, Object context) {
            Preconditions.checkState((boolean)ExpressionInterpreter.this.optimize, (Object)"not optimizing");
            try {
                return this.process(node, context);
            }
            catch (RuntimeException e) {
                return node;
            }
        }
    }
}

