/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.SubExpressionExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EqualityInference {
    private static final Ordering<Expression> CANONICAL_ORDERING = Ordering.from((Comparator)new Comparator<Expression>(){

        @Override
        public int compare(Expression expression1, Expression expression2) {
            return ComparisonChain.start().compare(DependencyExtractor.extractAll(expression1).size(), DependencyExtractor.extractAll(expression2).size()).compare(SubExpressionExtractor.extract(expression1).size(), SubExpressionExtractor.extract(expression2).size()).compare((Object)expression1, (Object)expression2, (Comparator)Ordering.arbitrary()).result();
        }
    });
    private final SetMultimap<Expression, Expression> equalitySets;
    private final Map<Expression, Expression> canonicalMap;

    private EqualityInference(Iterable<Set<Expression>> equalityGroups) {
        ImmutableSetMultimap.Builder setBuilder = ImmutableSetMultimap.builder();
        for (Set<Expression> equalityGroup : equalityGroups) {
            if (equalityGroup.isEmpty()) continue;
            setBuilder.putAll(CANONICAL_ORDERING.min(equalityGroup), equalityGroup);
        }
        this.equalitySets = setBuilder.build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.equalitySets.entries()) {
            Expression canonical = (Expression)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            mapBuilder.put((Object)expression, (Object)canonical);
        }
        this.canonicalMap = mapBuilder.build();
    }

    public Expression rewriteExpression(Expression expression, Predicate<Symbol> symbolScope) {
        Preconditions.checkArgument((boolean)DeterminismEvaluator.isDeterministic(expression), (Object)"Only deterministic expressions may be considered for rewrite");
        return this.rewriteExpression(expression, symbolScope, true);
    }

    private Expression rewriteExpression(Expression expression, Predicate<Symbol> symbolScope, boolean allowFullReplacement) {
        Iterable<Object> subExpressions = SubExpressionExtractor.extract(expression);
        if (!allowFullReplacement) {
            subExpressions = Iterables.filter(subExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)expression)));
        }
        ImmutableMap.Builder expressionRemap = ImmutableMap.builder();
        for (Expression subExpression : subExpressions) {
            Expression canonical = this.getScopedCanonical(subExpression, symbolScope);
            if (canonical == null) continue;
            expressionRemap.put((Object)subExpression, (Object)canonical);
        }
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner((Map<? extends Expression, ? extends Expression>)expressionRemap.build()), (Expression)expression);
        if (!EqualityInference.symbolToExpressionPredicate(symbolScope).apply((Object)rewritten)) {
            return null;
        }
        return rewritten;
    }

    public EqualityPartition generateEqualitiesPartitionedBy(Predicate<Symbol> symbolScope) {
        HashSet<Expression> scopeEqualities = new HashSet<Expression>();
        HashSet<Expression> scopeComplementEqualities = new HashSet<Expression>();
        HashSet<Expression> scopeStraddlingEqualities = new HashSet<Expression>();
        for (Collection equalitySet : this.equalitySets.asMap().values()) {
            HashSet<Expression> scopeExpressions = new HashSet<Expression>();
            HashSet<Expression> scopeComplementExpressions = new HashSet<Expression>();
            HashSet<Expression> scopeStraddlingExpressions = new HashSet<Expression>();
            for (Expression expression : equalitySet) {
                Expression scopeComplementRewritten;
                Expression scopeRewritten = this.rewriteExpression(expression, symbolScope, false);
                if (scopeRewritten != null) {
                    scopeExpressions.add(scopeRewritten);
                }
                if ((scopeComplementRewritten = this.rewriteExpression(expression, (Predicate<Symbol>)Predicates.not(symbolScope), false)) != null) {
                    scopeComplementExpressions.add(scopeComplementRewritten);
                }
                if (scopeRewritten != null || scopeComplementRewritten != null) continue;
                scopeStraddlingExpressions.add(expression);
            }
            Expression matchingCanonical = EqualityInference.getCanonical(scopeExpressions);
            if (scopeExpressions.size() >= 2) {
                for (Expression expression : Iterables.filter(scopeExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)matchingCanonical)))) {
                    scopeEqualities.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, matchingCanonical, expression));
                }
            }
            Expression complementCanonical = EqualityInference.getCanonical(scopeComplementExpressions);
            if (scopeComplementExpressions.size() >= 2) {
                for (Expression expression : Iterables.filter(scopeComplementExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)complementCanonical)))) {
                    scopeComplementEqualities.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, complementCanonical, expression));
                }
            }
            ImmutableList connectingExpressions = new ArrayList();
            connectingExpressions.add(matchingCanonical);
            connectingExpressions.add(complementCanonical);
            connectingExpressions.addAll(scopeStraddlingExpressions);
            Expression connectingCanonical = EqualityInference.getCanonical((Iterable<Expression>)(connectingExpressions = ImmutableList.copyOf((Iterable)Iterables.filter(connectingExpressions, (Predicate)Predicates.notNull()))));
            if (connectingCanonical == null) continue;
            for (Expression expression : Iterables.filter((Iterable)connectingExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)connectingCanonical)))) {
                scopeStraddlingEqualities.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, connectingCanonical, expression));
            }
        }
        return new EqualityPartition(scopeEqualities, scopeComplementEqualities, scopeStraddlingEqualities);
    }

    private static Expression getCanonical(Iterable<Expression> expressions) {
        if (Iterables.isEmpty(expressions)) {
            return null;
        }
        return (Expression)CANONICAL_ORDERING.min(expressions);
    }

    @VisibleForTesting
    Expression getScopedCanonical(Expression expression, Predicate<Symbol> symbolScope) {
        Expression canonicalIndex = this.canonicalMap.get(expression);
        if (canonicalIndex == null) {
            return null;
        }
        return EqualityInference.getCanonical(Iterables.filter((Iterable)this.equalitySets.get((Object)canonicalIndex), EqualityInference.symbolToExpressionPredicate(symbolScope)));
    }

    private static Predicate<Expression> symbolToExpressionPredicate(final Predicate<Symbol> symbolScope) {
        return new Predicate<Expression>(){

            public boolean apply(Expression expression) {
                return Iterables.all(DependencyExtractor.extractUnique(expression), (Predicate)symbolScope);
            }
        };
    }

    public static Predicate<Expression> isInferenceCandidate() {
        return new Predicate<Expression>(){

            public boolean apply(Expression expression) {
                ComparisonExpression comparison;
                if (DeterminismEvaluator.isDeterministic(expression) && expression instanceof ComparisonExpression && (comparison = (ComparisonExpression)expression).getType() == ComparisonExpression.Type.EQUAL) {
                    return !comparison.getLeft().equals((Object)comparison.getRight());
                }
                return false;
            }
        };
    }

    public static Iterable<Expression> nonInferrableConjuncts(Expression expression) {
        return Iterables.filter(ExpressionUtils.extractConjuncts(expression), (Predicate)Predicates.not(EqualityInference.isInferenceCandidate()));
    }

    public static EqualityInference createEqualityInference(Expression ... expressions) {
        Builder builder = new Builder();
        for (Expression expression : expressions) {
            builder.extractInferenceCandidates(expression);
        }
        return builder.build();
    }

    public static class Builder {
        private final Map<Expression, Expression> map = new HashMap<Expression, Expression>();
        private final Multimap<Expression, Expression> reverseMap = HashMultimap.create();

        public Builder extractInferenceCandidates(Expression expression) {
            return this.addAllEqualities(Iterables.filter(ExpressionUtils.extractConjuncts(expression), EqualityInference.isInferenceCandidate()));
        }

        public Builder addAllEqualities(Iterable<Expression> expressions) {
            for (Expression expression : expressions) {
                this.addEquality(expression);
            }
            return this;
        }

        public Builder addEquality(Expression expression) {
            Preconditions.checkArgument((boolean)EqualityInference.isInferenceCandidate().apply((Object)expression), (Object)("Expression must be a simple equality: " + expression));
            ComparisonExpression comparison = (ComparisonExpression)expression;
            this.addEquality(comparison.getLeft(), comparison.getRight());
            return this;
        }

        public Builder addEquality(Expression expression1, Expression expression2) {
            Preconditions.checkArgument((!expression1.equals((Object)expression2) ? 1 : 0) != 0, (Object)"need to provide equality between different expressions");
            Preconditions.checkArgument((boolean)DeterminismEvaluator.isDeterministic(expression1), (Object)("Expression must be deterministic: " + expression1));
            Preconditions.checkArgument((boolean)DeterminismEvaluator.isDeterministic(expression2), (Object)("Expression must be deterministic: " + expression2));
            Expression canonical1 = this.canonicalize(expression1);
            Expression canonical2 = this.canonicalize(expression2);
            if (!canonical1.equals((Object)canonical2)) {
                this.map.put(canonical1, canonical2);
                this.reverseMap.put((Object)canonical2, (Object)canonical1);
            }
            return this;
        }

        private Expression canonicalize(Expression expression) {
            while (this.map.containsKey(expression)) {
                expression = this.map.get(expression);
            }
            return expression;
        }

        private void collectEqualities(Expression expression, ImmutableSet.Builder<Expression> builder) {
            builder.add((Object)expression);
            for (Expression childExpression : this.reverseMap.get((Object)expression)) {
                this.collectEqualities(childExpression, builder);
            }
        }

        private Set<Expression> extractEqualExpressions(Expression expression) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            this.collectEqualities(this.canonicalize(expression), (ImmutableSet.Builder<Expression>)builder);
            return builder.build();
        }

        public EqualityInference build() {
            HashSet<Expression> seenCanonicals = new HashSet<Expression>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Expression expression : this.map.keySet()) {
                Expression canonical = this.canonicalize(expression);
                if (seenCanonicals.contains(canonical)) continue;
                builder.add(this.extractEqualExpressions(canonical));
                seenCanonicals.add(canonical);
            }
            return new EqualityInference((Iterable)builder.build());
        }
    }

    public static class EqualityPartition {
        private final List<Expression> scopeEqualities;
        private final List<Expression> scopeComplementEqualities;
        private final List<Expression> scopeStraddlingEqualities;

        public EqualityPartition(Iterable<Expression> scopeEqualities, Iterable<Expression> scopeComplementEqualities, Iterable<Expression> scopeStraddlingEqualities) {
            this.scopeEqualities = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(scopeEqualities, (Object)"scopeEqualities is null")));
            this.scopeComplementEqualities = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(scopeComplementEqualities, (Object)"scopeComplementEqualities is null")));
            this.scopeStraddlingEqualities = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(scopeStraddlingEqualities, (Object)"scopeStraddlingEqualities is null")));
        }

        public List<Expression> getScopeEqualities() {
            return this.scopeEqualities;
        }

        public List<Expression> getScopeComplementEqualities() {
            return this.scopeComplementEqualities;
        }

        public List<Expression> getScopeStraddlingEqualities() {
            return this.scopeStraddlingEqualities;
        }
    }
}

