/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class IsDistinctFromCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CompilerContext context = generatorContext.getContext();
        RowExpression left = arguments.get(0);
        RowExpression right = arguments.get(1);
        Type leftType = left.getType();
        Type rightType = right.getType();
        FunctionInfo operator = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
        Binding binding = generatorContext.getCallSiteBinder().bind(operator.getMethodHandle());
        Block equalsCall = new Block(context).comment("equals(%s, %s)", leftType, rightType).append(ByteCodeUtils.invoke(generatorContext.getContext(), binding, operator.getSignature()));
        Block block = new Block(context).comment("IS DISTINCT FROM").comment("left").append(generatorContext.generate(left)).append(new IfStatement(context, new Block(context).getVariable("wasNull"), new Block(context).pop(leftType.getJavaType()).putVariable("wasNull", false).comment("right is not null").append(generatorContext.generate(right)).pop(rightType.getJavaType()).getVariable("wasNull").invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE), new Block(context).comment("right").append(generatorContext.generate(right)).append(new IfStatement(context, new Block(context).getVariable("wasNull"), new Block(context).pop(leftType.getJavaType()).pop(rightType.getJavaType()).push(true), new Block(context).append(equalsCall).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE))))).putVariable("wasNull", false);
        return block;
    }
}

