/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import java.util.List;

public class ByteCodeGeneratorContext {
    private final ByteCodeExpressionVisitor byteCodeGenerator;
    private final CompilerContext context;
    private final CallSiteBinder callSiteBinder;
    private final FunctionRegistry registry;

    public ByteCodeGeneratorContext(ByteCodeExpressionVisitor byteCodeGenerator, CompilerContext context, CallSiteBinder callSiteBinder, FunctionRegistry registry) {
        Preconditions.checkNotNull((Object)byteCodeGenerator, (Object)"byteCodeGenerator is null");
        Preconditions.checkNotNull((Object)context, (Object)"context is null");
        Preconditions.checkNotNull((Object)callSiteBinder, (Object)"callSiteBinder is null");
        Preconditions.checkNotNull((Object)registry, (Object)"registry is null");
        this.byteCodeGenerator = byteCodeGenerator;
        this.context = context;
        this.callSiteBinder = callSiteBinder;
        this.registry = registry;
    }

    public CompilerContext getContext() {
        return this.context;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public ByteCodeNode generate(RowExpression expression) {
        return expression.accept(this.byteCodeGenerator, this.context);
    }

    public FunctionRegistry getRegistry() {
        return this.registry;
    }

    public ByteCodeNode generateCall(FunctionInfo function, List<ByteCodeNode> arguments) {
        Binding binding = this.callSiteBinder.bind(function.getMethodHandle());
        return ByteCodeUtils.generateInvocation(this.context, function, arguments, binding);
    }
}

