/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimeZoneNotSupportedException;
import com.google.common.base.Strings;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

final class ResourceUtil {
    private ResourceUtil() {
    }

    public static Session createSessionForRequest(HttpServletRequest servletRequest) {
        String language;
        Session.SessionBuilder sessionBuilder = Session.builder().setUser(ResourceUtil.getRequiredHeader(servletRequest, "X-Presto-User", "User")).setSource(servletRequest.getHeader("X-Presto-Source")).setCatalog(ResourceUtil.getRequiredHeader(servletRequest, "X-Presto-Catalog", "Catalog")).setSchema(ResourceUtil.getRequiredHeader(servletRequest, "X-Presto-Schema", "Schema")).setRemoteUserAddress(servletRequest.getRemoteAddr()).setUserAgent(servletRequest.getHeader("User-Agent"));
        String timeZoneId = servletRequest.getHeader("X-Presto-Time-Zone");
        if (timeZoneId != null) {
            sessionBuilder.setTimeZoneKey(ResourceUtil.getTimeZoneKey(timeZoneId));
        }
        if ((language = servletRequest.getHeader("X-Presto-Language")) != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(language));
        }
        return sessionBuilder.build();
    }

    private static String getRequiredHeader(HttpServletRequest servletRequest, String name, String description) {
        String user = servletRequest.getHeader(name);
        ResourceUtil.assertRequest(!Strings.isNullOrEmpty((String)user), description + " (%s) is empty", "X-Presto-User");
        return user;
    }

    public static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw ResourceUtil.badRequest(String.format(format, args));
        }
    }

    private static TimeZoneKey getTimeZoneKey(String timeZoneId) {
        try {
            return TimeZoneKey.getTimeZoneKey((String)timeZoneId);
        }
        catch (TimeZoneNotSupportedException e) {
            throw ResourceUtil.badRequest(e.getMessage());
        }
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }
}

