/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Iterator;

public final class PagesSerde {
    private PagesSerde() {
    }

    public static void writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Page ... pages) {
        PagesSerde.writePages(blockEncodingSerde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static void writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Iterable<Page> pages) {
        PagesSerde.writePages(blockEncodingSerde, sliceOutput, pages.iterator());
    }

    public static void writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Iterator<Page> pages) {
        PagesWriter pagesWriter = new PagesWriter(blockEncodingSerde, sliceOutput);
        while (pages.hasNext()) {
            pagesWriter.append(pages.next());
        }
    }

    public static Iterator<Page> readPages(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        return new PagesReader(blockEncodingSerde, sliceInput);
    }

    private static class PagesReader
    extends AbstractIterator<Page> {
        private final BlockEncoding[] blockEncodings;
        private final SliceInput sliceInput;

        public PagesReader(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
            this.sliceInput = sliceInput;
            if (!sliceInput.isReadable()) {
                this.endOfData();
                this.blockEncodings = new BlockEncoding[0];
                return;
            }
            int channelCount = sliceInput.readInt();
            this.blockEncodings = new BlockEncoding[channelCount];
            for (int i = 0; i < this.blockEncodings.length; ++i) {
                this.blockEncodings[i] = blockEncodingSerde.readBlockEncoding(sliceInput);
            }
        }

        protected Page computeNext() {
            if (!this.sliceInput.isReadable()) {
                return (Page)this.endOfData();
            }
            int positions = this.sliceInput.readInt();
            Block[] blocks = new Block[this.blockEncodings.length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = this.blockEncodings[i].readBlock(this.sliceInput);
            }
            Page page = new Page(positions, blocks);
            return page;
        }
    }

    private static class PagesWriter {
        private final BlockEncodingSerde blockEncodingSerde;
        private final SliceOutput sliceOutput;
        private BlockEncoding[] blockEncodings;

        private PagesWriter(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput) {
            this.blockEncodingSerde = (BlockEncodingSerde)Preconditions.checkNotNull((Object)blockEncodingSerde, (Object)"blockEncodingSerde is null");
            this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
        }

        public PagesWriter append(Page page) {
            int i;
            Block[] blocks;
            Preconditions.checkNotNull((Object)page, (Object)"page is null");
            if (this.blockEncodings == null) {
                blocks = page.getBlocks();
                this.blockEncodings = new BlockEncoding[blocks.length];
                this.sliceOutput.writeInt(blocks.length);
                for (i = 0; i < blocks.length; ++i) {
                    BlockEncoding blockEncoding;
                    Block block = blocks[i];
                    this.blockEncodings[i] = blockEncoding = block.getEncoding();
                    this.blockEncodingSerde.writeBlockEncoding(this.sliceOutput, blockEncoding);
                }
            }
            this.sliceOutput.writeInt(page.getPositionCount());
            blocks = page.getBlocks();
            for (i = 0; i < blocks.length; ++i) {
                this.blockEncodings[i].writeBlock(this.sliceOutput, blocks[i]);
            }
            return this;
        }
    }
}

