/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import java.util.Iterator;

public class EncodedBlockIterable
implements Iterable<Block> {
    private final BlockEncoding blockEncoding;
    private final Slice blocksSlice;

    public EncodedBlockIterable(BlockEncoding blockEncoding, Slice blocksSlice) {
        Preconditions.checkNotNull((Object)blockEncoding, (Object)"blockEncoding is null");
        Preconditions.checkNotNull((Object)blocksSlice, (Object)"blocksSlice is null");
        this.blockEncoding = blockEncoding;
        this.blocksSlice = blocksSlice;
    }

    @Override
    public Iterator<Block> iterator() {
        return new EncodedBlockIterator(this.blockEncoding, (SliceInput)this.blocksSlice.getInput());
    }

    private static class EncodedBlockIterator
    extends AbstractIterator<Block> {
        private final BlockEncoding blockEncoding;
        private final SliceInput sliceInput;

        private EncodedBlockIterator(BlockEncoding blockEncoding, SliceInput sliceInput) {
            this.blockEncoding = blockEncoding;
            this.sliceInput = sliceInput;
        }

        protected Block computeNext() {
            if (!this.sliceInput.isReadable()) {
                return (Block)this.endOfData();
            }
            Block block = this.blockEncoding.readBlock(this.sliceInput);
            return block;
        }
    }
}

