/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.dictionary.DictionaryBlockEncoding;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class DictionaryEncoder
implements Encoder {
    private final Type type;
    private final Encoder idWriter;
    private final GroupByHash dictionaryBuilder;
    private boolean finished;

    public DictionaryEncoder(Type type, Encoder idWriter) {
        this.type = type;
        this.idWriter = (Encoder)Preconditions.checkNotNull((Object)idWriter, (Object)"idWriter is null");
        this.dictionaryBuilder = new GroupByHash((List<? extends Type>)ImmutableList.of((Object)type), new int[]{0}, 1000);
    }

    @Override
    public Encoder append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        BlockBuilder idBlockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int key = this.dictionaryBuilder.putIfAbsent(position, block);
            BigintType.BIGINT.writeLong(idBlockBuilder, (long)key);
        }
        this.idWriter.append(idBlockBuilder.build());
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.type));
        for (int groupId = 0; groupId < this.dictionaryBuilder.getGroupCount(); ++groupId) {
            this.dictionaryBuilder.appendValuesTo(groupId, pageBuilder, 0);
        }
        return new DictionaryBlockEncoding(pageBuilder.build().getBlock(0), this.idWriter.finish());
    }
}

