/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.serde.BlocksFileStats;
import com.facebook.presto.serde.EncodedBlockIterable;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import java.util.Iterator;

public class BlocksFileReader
implements Iterable<Block> {
    private final BlockEncoding blockEncoding;
    private final Iterable<Block> blocks;
    private final BlocksFileStats stats;

    public static BlocksFileReader readBlocks(BlockEncodingSerde blockEncodingSerde, Slice slice) {
        return new BlocksFileReader(blockEncodingSerde, slice);
    }

    public BlocksFileReader(BlockEncodingSerde blockEncodingSerde, Slice slice) {
        Preconditions.checkNotNull((Object)slice, (Object)"slice is null");
        int footerLength = slice.getInt(slice.length() - 4);
        int footerOffset = slice.length() - footerLength - 4;
        Slice footerSlice = slice.slice(footerOffset, footerLength);
        BasicSliceInput input = footerSlice.getInput();
        this.blockEncoding = blockEncodingSerde.readBlockEncoding((SliceInput)input);
        this.stats = BlocksFileStats.deserialize((SliceInput)input);
        Slice blocksSlice = slice.slice(0, footerOffset);
        this.blocks = new EncodedBlockIterable(this.blockEncoding, blocksSlice);
    }

    public BlockEncoding getEncoding() {
        return this.blockEncoding;
    }

    public BlocksFileStats getStats() {
        return this.stats;
    }

    @Override
    public Iterator<Block> iterator() {
        return this.blocks.iterator();
    }
}

