/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;

public class PercentRankFunction
implements WindowFunction {
    private long totalCount;
    private long rank;
    private long count;

    @Override
    public Type getType() {
        return DoubleType.DOUBLE;
    }

    @Override
    public void reset(int partitionRowCount, PagesIndex pagesIndex) {
        this.totalCount = partitionRowCount;
        this.rank = 0L;
        this.count = 1L;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        if (this.totalCount == 1L) {
            DoubleType.DOUBLE.writeDouble(output, 0.0);
            return;
        }
        if (newPeerGroup) {
            this.rank += this.count;
            this.count = 1L;
        } else {
            ++this.count;
        }
        DoubleType.DOUBLE.writeDouble(output, (double)(this.rank - 1L) / (double)(this.totalCount - 1L));
    }
}

