/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Ints;
import java.util.List;

public class NthValueFunction
implements WindowFunction {
    private final Type type;
    private final int valueChannel;
    private final int offsetChannel;
    private int partitionStartPosition;
    private int partitionRowCount;
    private int currentPosition = -1;
    private PagesIndex pagesIndex;

    protected NthValueFunction(Type type, List<Integer> argumentChannels) {
        this.type = type;
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.get(1);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void reset(int partitionRowCount, PagesIndex pagesIndex) {
        this.partitionStartPosition += this.partitionRowCount;
        this.currentPosition = this.partitionStartPosition - 1;
        this.partitionRowCount = partitionRowCount;
        this.pagesIndex = pagesIndex;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        ++this.currentPosition;
        if (this.pagesIndex.isNull(this.offsetChannel, this.currentPosition)) {
            output.appendNull();
            return;
        }
        int offset = Ints.checkedCast((long)this.pagesIndex.getLong(this.offsetChannel, this.currentPosition));
        Failures.checkCondition(offset >= 1, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 1", new Object[0]);
        int valuePosition = this.partitionStartPosition + offset - 1;
        if (valuePosition >= this.partitionStartPosition + this.partitionRowCount) {
            output.appendNull();
            return;
        }
        this.pagesIndex.appendTo(this.valueChannel, valuePosition, output);
    }

    public static class VarcharNthValueFunction
    extends NthValueFunction {
        public VarcharNthValueFunction(List<Integer> argumentChannels) {
            super((Type)VarcharType.VARCHAR, argumentChannels);
        }
    }

    public static class DoubleNthValueFunction
    extends NthValueFunction {
        public DoubleNthValueFunction(List<Integer> argumentChannels) {
            super((Type)DoubleType.DOUBLE, argumentChannels);
        }
    }

    public static class BooleanNthValueFunction
    extends NthValueFunction {
        public BooleanNthValueFunction(List<Integer> argumentChannels) {
            super((Type)BooleanType.BOOLEAN, argumentChannels);
        }
    }

    public static class BigintNthValueFunction
    extends NthValueFunction {
        public BigintNthValueFunction(List<Integer> argumentChannels) {
            super((Type)BigintType.BIGINT, argumentChannels);
        }
    }
}

