/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;

public class MapSubscriptOperator
extends ParametricOperator {
    public static final MapSubscriptOperator MAP_SUBSCRIPT = new MapSubscriptOperator();
    private static final JsonExtract.JsonExtractor<Long> LONG_JSON_EXTRACTOR = new LongJsonExtractor();
    private static final JsonExtract.JsonExtractor<Boolean> BOOLEAN_JSON_EXTRACTOR = new BooleanJsonExtractor();
    private static final JsonExtract.JsonExtractor<Double> DOUBLE_JSON_EXTRACTOR = new DoubleJsonExtractor();
    private static final JsonExtract.JsonExtractor<Slice> SLICE_JSON_EXTRACTOR = new JsonExtract.ScalarValueJsonExtractor();

    protected MapSubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "V", (List<String>)ImmutableList.of((Object)"map<K,V>", (Object)"K"));
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        return new FunctionInfo(new Signature(OperatorType.SUBSCRIPT.name(), valueType.getName(), TypeUtils.parameterizedTypeName("map", keyType.getName(), valueType.getName()), keyType.getName()), "Map subscript", true, MapSubscriptOperator.lookupMethod(keyType.getJavaType(), valueType.getJavaType()), true, true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    private static MethodHandle lookupMethod(Class<?> keyJavaType, Class<?> valueJavaType) {
        String methodName = keyJavaType.getSimpleName() + valueJavaType.getSimpleName() + "Subscript";
        try {
            return MethodHandles.lookup().unreflect(MapSubscriptOperator.class.getMethod(methodName, Slice.class, keyJavaType));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Long SlicelongSubscript(Slice map, Slice key) {
        return MapSubscriptOperator.subscript(map, key.toStringUtf8(), LONG_JSON_EXTRACTOR);
    }

    public static Boolean SlicebooleanSubscript(Slice map, Slice key) {
        return MapSubscriptOperator.subscript(map, key.toStringUtf8(), BOOLEAN_JSON_EXTRACTOR);
    }

    public static Double SlicedoubleSubscript(Slice map, Slice key) {
        return MapSubscriptOperator.subscript(map, key.toStringUtf8(), DOUBLE_JSON_EXTRACTOR);
    }

    public static Slice SliceSliceSubscript(Slice map, Slice key) {
        return MapSubscriptOperator.subscript(map, key.toStringUtf8(), SLICE_JSON_EXTRACTOR);
    }

    public static Long doublelongSubscript(Slice map, double key) {
        return MapSubscriptOperator.subscript(map, key, LONG_JSON_EXTRACTOR);
    }

    public static Boolean doublebooleanSubscript(Slice map, double key) {
        return MapSubscriptOperator.subscript(map, key, BOOLEAN_JSON_EXTRACTOR);
    }

    public static Double doubledoubleSubscript(Slice map, double key) {
        return MapSubscriptOperator.subscript(map, key, DOUBLE_JSON_EXTRACTOR);
    }

    public static Slice doubleSliceSubscript(Slice map, double key) {
        return MapSubscriptOperator.subscript(map, key, SLICE_JSON_EXTRACTOR);
    }

    public static Long booleanlongSubscript(Slice map, boolean key) {
        return MapSubscriptOperator.subscript(map, key, LONG_JSON_EXTRACTOR);
    }

    public static Boolean booleanbooleanSubscript(Slice map, boolean key) {
        return MapSubscriptOperator.subscript(map, key, BOOLEAN_JSON_EXTRACTOR);
    }

    public static Double booleandoubleSubscript(Slice map, boolean key) {
        return MapSubscriptOperator.subscript(map, key, DOUBLE_JSON_EXTRACTOR);
    }

    public static Slice booleanSliceSubscript(Slice map, boolean key) {
        return MapSubscriptOperator.subscript(map, key, SLICE_JSON_EXTRACTOR);
    }

    public static Long longlongSubscript(Slice map, long key) {
        return MapSubscriptOperator.subscript(map, key, LONG_JSON_EXTRACTOR);
    }

    public static Boolean longbooleanSubscript(Slice map, long key) {
        return MapSubscriptOperator.subscript(map, key, BOOLEAN_JSON_EXTRACTOR);
    }

    public static Double longdoubleSubscript(Slice map, long key) {
        return MapSubscriptOperator.subscript(map, key, DOUBLE_JSON_EXTRACTOR);
    }

    public static Slice longSliceSubscript(Slice map, long key) {
        return MapSubscriptOperator.subscript(map, key, SLICE_JSON_EXTRACTOR);
    }

    private static <T> T subscript(Slice map, Object key, JsonExtract.JsonExtractor<T> extractor) {
        extractor = JsonExtract.generateExtractor(String.format("$[\"%s\"]", key.toString()), extractor);
        return JsonExtract.extract(map, extractor);
    }

    public static class LongJsonExtractor
    implements JsonExtract.JsonExtractor<Long> {
        @Override
        public Long extract(JsonParser jsonParser) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            if (token == null) {
                throw new JsonParseException("Unexpected end of value", jsonParser.getCurrentLocation());
            }
            if (!token.isScalarValue() || token == JsonToken.VALUE_NULL) {
                return null;
            }
            return jsonParser.getLongValue();
        }
    }

    public static class DoubleJsonExtractor
    implements JsonExtract.JsonExtractor<Double> {
        @Override
        public Double extract(JsonParser jsonParser) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            if (token == null) {
                throw new JsonParseException("Unexpected end of value", jsonParser.getCurrentLocation());
            }
            if (!token.isScalarValue() || token == JsonToken.VALUE_NULL) {
                return null;
            }
            return jsonParser.getDoubleValue();
        }
    }

    public static class BooleanJsonExtractor
    implements JsonExtract.JsonExtractor<Boolean> {
        @Override
        public Boolean extract(JsonParser jsonParser) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            if (token == null) {
                throw new JsonParseException("Unexpected end of value", jsonParser.getCurrentLocation());
            }
            if (!token.isScalarValue() || token == JsonToken.VALUE_NULL) {
                return null;
            }
            return jsonParser.getBooleanValue();
        }
    }
}

